/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.microchip.panel;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRClientShaders;
import net.swedz.little_big_redstone.gui.microchip.panel.MicrochipRenderPanel;
import net.swedz.little_big_redstone.gui.microchip.widget.MicrochipWidgetContext;
import net.swedz.little_big_redstone.gui.microchip.wire.WireEndpoints;
import net.swedz.little_big_redstone.gui.microchip.wire.WirePathing;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.wire.Wire;
import net.swedz.tesseract.neoforge.api.Bounds;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public final class MicrochipRenderWiresPanel
extends MicrochipRenderPanel {
    private final int wireSize;
    private final int wirePadding;
    private final int wirePortPadding;
    private final WirePathing pathing;

    public MicrochipRenderWiresPanel(DyeColor color, Microchip microchip, Supplier<MicrochipWidgetContext> context) {
        super(color, microchip, context);
        this.wireSize = 2;
        this.wirePadding = 1;
        this.wirePortPadding = 3;
        int componentPadding = this.wirePortPadding + 1;
        this.pathing = new WirePathing(microchip, 0, b -> new Bounds(b.minX() - componentPadding, b.minY() - componentPadding, b.width() + componentPadding * 2 - 1, b.height() + componentPadding * 2 - 1));
    }

    public MicrochipRenderWiresPanel(DyeColor color, Microchip microchip) {
        this(color, microchip, null);
    }

    public WirePathing pathing() {
        return this.pathing;
    }

    public void rebuildPaths() {
        this.pathing.forgetEverything();
    }

    public boolean isHovering(Wire wire, int boardMouseX, int boardMouseY) {
        return this.pathing.contains(wire, boardMouseX, boardMouseY, this.wireSize, this.wirePadding);
    }

    public Wire findHoveredWire(int boardMouseX, int boardMouseY) {
        ArrayList backwardsWires = Lists.newArrayList((Iterable)this.microchip.wires());
        Collections.reverse(backwardsWires);
        for (Wire wire : backwardsWires) {
            if (!this.isHovering(wire, boardMouseX, boardMouseY)) continue;
            return wire;
        }
        return null;
    }

    @Override
    public void render(TesseractGuiGraphics graphics) {
        this.renderAllWires(graphics);
    }

    private void renderAllWires(TesseractGuiGraphics graphics) {
        MicrochipWidgetContext context = this.context();
        for (Wire wire : this.microchip.wires()) {
            if (context != null && context.topLayerWires().contains(wire)) continue;
            this.renderWire(graphics, wire, false);
        }
        if (context != null) {
            graphics = graphics.inner();
            graphics.enableBatching();
            for (Wire wire : context.topLayerWires()) {
                this.renderWire(graphics, wire, !context.widget().hasSelectedPort() && (context.wire() == null || context.wire() == wire));
            }
            if (context.widget().hasSelectedPort() && context.isOnBoard() && this.microchip.findAt(context.boardMouseX(), context.boardMouseY()) == null) {
                WireEndpoints endpoints = WireEndpoints.heldWire(context);
                this.renderWire(graphics, endpoints, true);
            }
            graphics.end();
        }
    }

    private void renderWire(TesseractGuiGraphics graphics, Wire wire, boolean hovered) {
        this.renderWire(graphics, wire, WireEndpoints.of(this.color, this.microchip, wire), hovered);
    }

    public void renderWire(TesseractGuiGraphics graphics, WireEndpoints endpoints, boolean hovered) {
        this.renderWire(graphics, (Either<Wire, List<Bounds>>)Either.left(null), endpoints, hovered);
    }

    public void renderWire(TesseractGuiGraphics graphics, Wire wire, WireEndpoints endpoints, boolean hovered) {
        this.renderWire(graphics, (Either<Wire, List<Bounds>>)Either.left((Object)wire), endpoints, hovered);
    }

    public void renderWire(TesseractGuiGraphics graphics, List<Bounds> avoidBounds, WireEndpoints endpoints, boolean hovered) {
        this.renderWire(graphics, (Either<Wire, List<Bounds>>)Either.right(avoidBounds), endpoints, hovered);
    }

    private void renderWire(TesseractGuiGraphics graphics, Either<Wire, List<Bounds>> eitherWireOrBounds, WireEndpoints endpoints, boolean hovered) {
        if (endpoints.valid()) {
            this.renderWire(graphics, eitherWireOrBounds, endpoints.startX(), endpoints.startY(), endpoints.endX(), endpoints.endY(), hovered, endpoints.usePadding(), endpoints.powered(), endpoints.argb());
        }
    }

    private void renderWire(TesseractGuiGraphics graphics, Either<Wire, List<Bounds>> eitherWireOrBounds, int startX, int startY, int endX, int endY, boolean hovered, boolean usePadding, boolean powered, int argb) {
        boolean renderEnd;
        int maxX = this.microchip.size().bounds().maxX();
        int maxY = this.microchip.size().bounds().maxY();
        int portPadding = usePadding ? this.wirePortPadding : 0;
        boolean renderStart = startX >= 0 && startX < maxX && startY >= 0 && startY < maxY;
        boolean bl = renderEnd = endX - portPadding >= 0 && endX - portPadding < maxX && endY >= 0 && endY < maxY;
        if (renderStart || renderEnd) {
            List path = (List)eitherWireOrBounds.map(wire -> this.pathing.get((Wire)wire, startX + portPadding, startY, endX - portPadding - this.wireSize, endY), avoidBounds -> this.pathing.build(startX + portPadding, startY, endX - portPadding - this.wireSize, endY, (List<Bounds>)avoidBounds));
            if (hovered) {
                graphics = graphics.inner();
                graphics.enableBatching();
                graphics.setTextureShader(LBRClientShaders::pulsingTextureLightness);
            }
            graphics.setColor(argb);
            graphics.setTexture(LBR.id("textures/gui/container/microchip/wire_%s.png".formatted(powered ? "on" : "off")));
            if (renderStart) {
                graphics.blit(startX, startY, (float)startX, (float)startY, portPadding, this.wireSize, 16, 16);
            }
            if (renderEnd) {
                graphics.blit(endX - portPadding, endY, (float)(endX - portPadding), (float)endY, portPadding, this.wireSize, 16, 16);
            }
            for (WirePathing.Position position : path) {
                if (position.x() < 0 || position.y() < 0 || position.x() >= maxX || position.y() >= maxY) continue;
                graphics.blit(position.x(), position.y(), (float)position.x(), (float)position.y(), this.wireSize, this.wireSize, 16, 16);
            }
            graphics.resetColor();
            if (hovered) {
                graphics.resetTextureShader();
                graphics.end();
            }
        }
    }
}

