/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.swedz.little_big_redstone.LBR;
import net.swedz.tesseract.neoforge.api.Assert;

@EventBusSubscriber(modid="little_big_redstone", value={Dist.CLIENT})
public final class LBRClientModels {
    private static final Map<DyeColor, ModelResourceLocation> STICKY_NOTES;

    public static ModelResourceLocation stickyNote(DyeColor color) {
        Assert.notNull((Object)color);
        return STICKY_NOTES.get(color);
    }

    @SubscribeEvent
    private static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        STICKY_NOTES.values().forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
    }

    static {
        HashMap stickyNotes = Maps.newHashMap();
        for (DyeColor color : DyeColor.values()) {
            stickyNotes.put(color, ModelResourceLocation.standalone((ResourceLocation)LBR.id("block/%s_sticky_note".formatted(color.getName()))));
        }
        STICKY_NOTES = Collections.unmodifiableMap(stickyNotes);
    }
}

