/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.dysoncubeproject.util;

import java.text.DecimalFormat;

public class NumberUtils {
    private static final String[] suffixes = new String[]{"", "K", "M", "B", "T", "Q", "Qi", "Sx", "Sp", "O"};
    private static DecimalFormat formatterWithUnits = new DecimalFormat("####0.#");

    public static String getFormatedBigNumber(double value) {
        if (value < 1000.0) {
            return String.valueOf((int)Math.ceil(value));
        }
        int exp = (int)(Math.log(value) / Math.log(1000.0));
        if (exp >= suffixes.length) {
            return "Err";
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.#");
        return decimalFormat.format(value / Math.pow(1000.0, exp)) + suffixes[exp];
    }

    public static double customCeil(double value) {
        if (value == (double)((long)value)) {
            return value;
        }
        return value > 0.0 ? (double)((long)value + 1L) : (double)((long)value);
    }
}

