/*
 * Decompiled with CFR 0.152.
 */
package einstein.usefulslime.mixin;

import com.mojang.authlib.GameProfile;
import einstein.usefulslime.UsefulSlime;
import einstein.usefulslime.util.ClimbingEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player {
    @Unique
    private final ClimbingEntity usefulSlime$climbingEntity = (ClimbingEntity)((Object)this);
    @Unique
    private int usefulSlime$distanceWallClimbed = 0;
    @Unique
    private int usefulSlime$distanceHangClimbed = 0;

    public ServerPlayerMixin(Level level, BlockPos pos, float yHeadRot, GameProfile profile) {
        super(level, pos, yHeadRot, profile);
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="TAIL")})
    private void checkMovementStatistics(double distanceX, double distanceY, double distanceZ, CallbackInfo ci) {
        if (!this.level().isClientSide && !this.isPassenger() && this.onClimbable()) {
            if (this.usefulSlime$climbingEntity.usefulSlime$canWallClimb() && distanceY > 0.0) {
                ++this.usefulSlime$distanceWallClimbed;
                if (this.usefulSlime$distanceWallClimbed % (this.random.nextInt(2, 4) * 10) == 0) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.SLIME_BLOCK_STEP, this.getSoundSource(), 0.15f, 1.0f);
                }
                if (this.usefulSlime$distanceWallClimbed >= 100 && UsefulSlime.CONFIGS.wallClimbingDamagesSlimeChestplateAndLeggings) {
                    this.usefulSlime$distanceWallClimbed = 0;
                    UsefulSlime.damageEquipment((LivingEntity)this, EquipmentSlot.CHEST);
                    UsefulSlime.damageEquipment((LivingEntity)this, EquipmentSlot.LEGS);
                }
            }
            if (this.usefulSlime$climbingEntity.usefulSlime$canHangClimb() && Math.sqrt(distanceX * distanceX + distanceZ * distanceZ) > 0.0) {
                ++this.usefulSlime$distanceHangClimbed;
                if (this.usefulSlime$distanceHangClimbed % (this.random.nextInt(2, 4) * 10) == 0) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.SLIME_BLOCK_STEP, this.getSoundSource(), 0.15f, 1.0f);
                }
                if (this.usefulSlime$distanceHangClimbed >= 50 && UsefulSlime.CONFIGS.hangClimbingDamagesSlimeHelmet) {
                    this.usefulSlime$distanceHangClimbed = 0;
                    UsefulSlime.damageEquipment((LivingEntity)this, EquipmentSlot.HEAD);
                }
            }
        }
    }
}

