/*
 * Decompiled with CFR 0.152.
 */
package einstein.usefulslime.mixin;

import einstein.usefulslime.UsefulSlime;
import einstein.usefulslime.init.ModBlocks;
import einstein.usefulslime.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    private final LivingEntity usefulSlime$me = (LivingEntity)this;

    @Shadow
    public abstract boolean isAlive();

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @Shadow
    public abstract boolean isFallFlying();

    public LivingEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Inject(method={"travel"}, at={@At(value="TAIL")})
    private void travel(Vec3 travelVector, CallbackInfo ci) {
        BlockPos belowPos = this.getBlockPosBelowThatAffectsMyMovement();
        BlockState belowState = this.level().getBlockState(belowPos);
        if (belowState.is(ModBlocks.SLIPPERY_SLIME_BLOCK.get())) {
            int max = UsefulSlime.CONFIGS.maxSlipperySlimeBlockSpeed;
            Vec3 movement = this.getDeltaMovement();
            if (movement.x > (double)max) {
                this.setDeltaMovement(max, movement.y, movement.z);
            }
            if (movement.z > (double)max) {
                this.setDeltaMovement(movement.x, movement.y, max);
            }
            if (movement.x < (double)(-max)) {
                this.setDeltaMovement(-max, movement.y, movement.z);
            }
            if (movement.z < (double)(-max)) {
                this.setDeltaMovement(movement.x, movement.y, -max);
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (!this.isInvulnerableTo(source) && this.isFallFlying() && source.is(DamageTypes.FLY_INTO_WALL) && this.isAlive() && this.getItemBySlot(EquipmentSlot.HEAD).is(ModItems.SLIME_HELMET.get())) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.SLIME_SQUISH, this.getSoundSource(), 1.0f, 1.0f);
            UsefulSlime.damageEquipment(this.usefulSlime$me, EquipmentSlot.HEAD, Math.round(amount / 2.0f));
            cir.setReturnValue((Object)false);
        }
    }
}

