/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.crafter.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mcjty.lib.varia.InventoryTools;
import mcjty.rftoolsutility.modules.crafter.data.CraftMode;
import mcjty.rftoolsutility.modules.crafter.data.KeepMode;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CraftingRecipe {
    private CraftingInput.Positioned inv = CraftingInput.ofPositioned((int)3, (int)3, CraftingRecipe.createList());
    private ItemStack result = ItemStack.EMPTY;
    private boolean recipePresent = false;
    private Recipe recipe = null;
    private KeepMode keepOne = KeepMode.ALL;
    private CraftMode craftMode = CraftMode.EXT;
    public static final Codec<CraftingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("inv").forGetter(CraftingRecipe::convertTo3x3Grid), (App)ItemStack.OPTIONAL_CODEC.fieldOf("result").forGetter(o -> o.result), (App)KeepMode.CODEC.fieldOf("keepOne").forGetter(CraftingRecipe::getKeepOne), (App)CraftMode.CODEC.fieldOf("craftMode").forGetter(CraftingRecipe::getCraftMode)).apply((Applicative)instance, (itemStacks, itemStack, keepMode, craftMode) -> {
        CraftingRecipe recipe = new CraftingRecipe();
        recipe.inv = CraftingInput.ofPositioned((int)3, (int)3, CraftingRecipe.convertTo3x3List(itemStacks));
        recipe.result = itemStack;
        recipe.keepOne = keepMode;
        recipe.craftMode = craftMode;
        recipe.recipePresent = false;
        return recipe;
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, CraftingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()), CraftingRecipe::convertTo3x3Grid, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, o -> o.result, KeepMode.STREAM_CODEC, CraftingRecipe::getKeepOne, CraftMode.STREAM_CODEC, CraftingRecipe::getCraftMode, (itemStacks, itemStack, keepMode, craftMode) -> {
        CraftingRecipe recipe = new CraftingRecipe();
        recipe.inv = CraftingInput.ofPositioned((int)3, (int)3, CraftingRecipe.convertTo3x3List(itemStacks));
        recipe.result = itemStack;
        recipe.keepOne = keepMode;
        recipe.craftMode = craftMode;
        recipe.recipePresent = false;
        return recipe;
    });
    private List<CompressedIngredient> compressedIngredients = null;

    private static List<ItemStack> createList() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            list.add(ItemStack.EMPTY);
        }
        return list;
    }

    public CraftingRecipe copy() {
        CraftingRecipe recipe = new CraftingRecipe();
        recipe.inv = CraftingInput.ofPositioned((int)3, (int)3, CraftingRecipe.convertTo3x3List(this.inv.input().items()));
        recipe.result = this.result.copy();
        recipe.keepOne = this.keepOne;
        recipe.craftMode = this.craftMode;
        recipe.recipePresent = false;
        return recipe;
    }

    public List<ItemStack> convertTo3x3Grid() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(9);
        for (int i = 0; i < 9; ++i) {
            list.add(ItemStack.EMPTY);
        }
        int left = this.inv.left();
        int top = this.inv.top();
        int size = this.inv.input().size();
        for (int x = 0; x < this.inv.input().width(); ++x) {
            for (int y = 0; y < this.inv.input().height(); ++y) {
                int idx = y * this.inv.input().width() + x;
                if (idx >= size) continue;
                int gridIdx = (y + top) * 3 + x + left;
                list.set(gridIdx, this.inv.input().getItem(idx));
            }
        }
        return list;
    }

    private static List<ItemStack> convertTo3x3List(List<ItemStack> list) {
        if (list.size() == 9) {
            return list;
        }
        ArrayList<ItemStack> newList = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            newList.add(i < list.size() ? list.get(i) : ItemStack.EMPTY);
        }
        return newList;
    }

    public List<CompressedIngredient> getCompressedIngredients() {
        if (this.compressedIngredients == null) {
            this.compressedIngredients = new ArrayList<CompressedIngredient>();
            for (int i = 0; i < this.inv.input().size(); ++i) {
                ItemStack stack = this.inv.input().getItem(i);
                if (stack.isEmpty()) continue;
                boolean found = false;
                for (CompressedIngredient ingredient : this.compressedIngredients) {
                    if (!InventoryTools.isItemStackConsideredEqual((ItemStack)stack, (ItemStack)ingredient.getStack())) continue;
                    ingredient.getStack().grow(stack.getCount());
                    int[] nArray = ingredient.getGridDistribution();
                    int n = i;
                    nArray[n] = nArray[n] + stack.getCount();
                    found = true;
                    break;
                }
                if (found) continue;
                CompressedIngredient ingredient = new CompressedIngredient(stack.copy());
                int[] nArray = ingredient.getGridDistribution();
                int n = i;
                nArray[n] = nArray[n] + stack.getCount();
                this.compressedIngredients.add(ingredient);
            }
        }
        return this.compressedIngredients;
    }

    public static Recipe findRecipe(Level world, CraftingInput inv) {
        RecipeManager recipeManager = world.getRecipeManager();
        Optional recipeFor = recipeManager.getRecipeFor(RecipeType.CRAFTING, (RecipeInput)inv, world);
        if (recipeFor.isPresent()) {
            return ((RecipeHolder)recipeFor.get()).value();
        }
        return null;
    }

    public void setRecipe(ItemStack[] items, ItemStack result) {
        this.inv = CraftingInput.ofPositioned((int)3, (int)3, Arrays.asList(items));
        this.result = result;
        this.recipePresent = false;
    }

    public CraftingInput.Positioned getInventory() {
        return this.inv;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public Recipe getCachedRecipe(Level world) {
        if (!this.recipePresent) {
            this.recipePresent = true;
            this.recipe = CraftingRecipe.findRecipe(world, this.inv.input());
            this.compressedIngredients = null;
        }
        return this.recipe;
    }

    public KeepMode getKeepOne() {
        return this.keepOne;
    }

    public void setKeepOne(KeepMode keepOne) {
        this.keepOne = keepOne;
    }

    public CraftMode getCraftMode() {
        return this.craftMode;
    }

    public void setCraftMode(CraftMode craftMode) {
        this.craftMode = craftMode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CraftingRecipe)) {
            return false;
        }
        CraftingRecipe that = (CraftingRecipe)o;
        return Objects.equals(this.inv, that.inv) && ItemStack.isSameItemSameComponents((ItemStack)this.result, (ItemStack)that.result) && this.keepOne == that.keepOne && this.craftMode == that.craftMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inv, ItemStack.hashItemAndComponents((ItemStack)this.result), this.keepOne, this.craftMode});
    }

    public static class CompressedIngredient {
        private final ItemStack stack;
        private final int[] gridDistribution = new int[9];

        public CompressedIngredient(ItemStack stack) {
            this.stack = stack;
            Arrays.fill(this.gridDistribution, 0);
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int[] getGridDistribution() {
            return this.gridDistribution;
        }
    }
}

