/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.singularity;

import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.crafting.recipe.UltimateSingularityRecipe;
import com.blakebr0.extendedcrafting.lib.ModSingularities;
import com.blakebr0.extendedcrafting.network.payload.SyncSingularitiesPayload;
import com.blakebr0.extendedcrafting.singularity.Singularity;
import com.blakebr0.extendedcrafting.singularity.SingularityUtils;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;

public final class SingularityRegistry {
    private static final SingularityRegistry INSTANCE = new SingularityRegistry();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<ResourceLocation, Singularity> singularities = new LinkedHashMap<ResourceLocation, Singularity>();

    @SubscribeEvent
    public void onDatapackSync(OnDatapackSyncEvent event) {
        SyncSingularitiesPayload payload = new SyncSingularitiesPayload(this.getSingularities());
        ServerPlayer player = event.getPlayer();
        if (player != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void loadSingularities() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        File dir = FMLPaths.CONFIGDIR.get().resolve("extendedcrafting/singularities/").toFile();
        this.writeDefaultSingularityFiles();
        this.singularities.clear();
        if (!dir.mkdirs() && dir.isDirectory()) {
            this.loadFiles(dir);
        }
        UltimateSingularityRecipe.invalidate();
        stopwatch.stop();
        ExtendedCrafting.LOGGER.info("Loaded {} singularity type(s) in {} ms", (Object)this.singularities.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDefaultSingularityFiles() {
        File dir = FMLPaths.CONFIGDIR.get().resolve("extendedcrafting/singularities/").toFile();
        if (!dir.exists() && dir.mkdirs()) {
            for (Singularity singularity : ModSingularities.getDefaults()) {
                JsonObject json = SingularityUtils.writeToJson(singularity);
                FileWriter writer = null;
                try {
                    File file = new File(dir, singularity.getId().getPath() + ".json");
                    writer = new FileWriter(file);
                    GSON.toJson((JsonElement)json, (Appendable)writer);
                    writer.close();
                    IOUtils.closeQuietly((Writer)writer);
                }
                catch (Exception e) {
                    ExtendedCrafting.LOGGER.error("An error occurred while generating default singularities", (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly(writer);
                }
            }
        }
    }

    public List<Singularity> getSingularities() {
        return Lists.newArrayList(this.singularities.values());
    }

    public Singularity getSingularityById(ResourceLocation id) {
        return this.singularities.get(id);
    }

    public void loadSingularities(SyncSingularitiesPayload payload) {
        Map<ResourceLocation, Singularity> singularities = payload.singularities().stream().collect(Collectors.toMap(Singularity::getId, s -> s));
        this.singularities.clear();
        this.singularities.putAll(singularities);
        UltimateSingularityRecipe.invalidate();
        ExtendedCrafting.LOGGER.info("Loaded {} singularities from the server", (Object)singularities.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFiles(File dir) {
        File[] files = dir.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            InputStreamReader reader = null;
            Singularity singularity = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                String name = file.getName().replace(".json", "");
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                singularity = SingularityUtils.loadFromJson(ExtendedCrafting.resource(name), json);
                reader.close();
            }
            catch (Exception e) {
                try {
                    ExtendedCrafting.LOGGER.error("An error occurred while loading singularities", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            IOUtils.closeQuietly((Reader)reader);
            if (singularity == null || !singularity.isEnabled()) continue;
            ResourceLocation id = singularity.getId();
            this.singularities.put(id, singularity);
        }
    }

    public static SingularityRegistry getInstance() {
        return INSTANCE;
    }
}

