/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.item;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.component.RecipeMakerComponent;
import com.blakebr0.extendedcrafting.compat.crafttweaker.CraftTweakerUtils;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModDataComponentTypes;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.tileentity.AdvancedTableTileEntity;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import com.blakebr0.extendedcrafting.tileentity.BasicTableTileEntity;
import com.blakebr0.extendedcrafting.tileentity.CraftingCoreTileEntity;
import com.blakebr0.extendedcrafting.tileentity.EliteTableTileEntity;
import com.blakebr0.extendedcrafting.tileentity.EnderCrafterTileEntity;
import com.blakebr0.extendedcrafting.tileentity.FluxCrafterTileEntity;
import com.blakebr0.extendedcrafting.tileentity.UltimateTableTileEntity;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.items.IItemHandler;

public class RecipeMakerItem
extends BaseItem {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String NEW_LINE = System.lineSeparator() + "\t";
    private static final char[] KEYS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-_*/".toCharArray();

    public RecipeMakerItem() {
        super(p -> p.stacksTo(1).component(ModDataComponentTypes.RECIPE_MAKER, (Object)RecipeMakerComponent.EMPTY));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getClickedFace();
        Level level = context.getLevel();
        if (player == null || !player.mayUseItemAt(pos.relative(facing), facing, stack)) {
            return InteractionResult.PASS;
        }
        BlockEntity tile = level.getBlockEntity(pos);
        if (RecipeMakerItem.isTable(tile)) {
            if (level.isClientSide()) {
                String string;
                TableType table;
                String type = RecipeMakerItem.getType(stack);
                BaseItemStackHandler inventory = ((BaseInventoryTileEntity)tile).getInventory();
                TableType tableType = tile instanceof EnderCrafterTileEntity ? TableType.ENDER_CRAFTER : (table = tile instanceof FluxCrafterTileEntity ? TableType.FLUX_CRAFTER : TableType.TABLE);
                if ("CraftTweaker".equals(type)) {
                    string = RecipeMakerItem.isShapeless(stack) ? RecipeMakerItem.makeShapelessCraftTweakerTableRecipe((IItemHandler)inventory, table) : RecipeMakerItem.makeShapedCraftTweakerTableRecipe((IItemHandler)inventory, table);
                } else {
                    RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)level.registryAccess());
                    String string2 = string = RecipeMakerItem.isShapeless(stack) ? RecipeMakerItem.makeShapelessDatapackTableRecipe((IItemHandler)inventory, table, (DynamicOps<JsonElement>)ops) : RecipeMakerItem.makeShapedDatapackTableRecipe((IItemHandler)inventory, table, (DynamicOps<JsonElement>)ops);
                    if ("TOO MANY ITEMS".equals(string)) {
                        player.sendSystemMessage((Component)Localizable.of((String)"message.extendedcrafting.max_unique_items_exceeded").args(new Object[]{KEYS.length}).build());
                        return InteractionResult.SUCCESS;
                    }
                }
                RecipeMakerItem.setClipboard(string);
                player.sendSystemMessage((Component)Localizable.of((String)"message.extendedcrafting.copied_recipe").build());
                if (((Boolean)ModConfigs.RECIPE_MAKER_USE_DATA_COMPONENTS.get()).booleanValue() && "CraftTweaker".equals(type) && !ModConfigs.isCraftTweakerInstalled()) {
                    player.sendSystemMessage((Component)Localizable.of((String)"message.extendedcrafting.data_components_requires_crafttweaker").build());
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (tile instanceof CraftingCoreTileEntity) {
            CraftingCoreTileEntity core = (CraftingCoreTileEntity)tile;
            if (level.isClientSide()) {
                String type = RecipeMakerItem.getType(stack);
                RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)level.registryAccess());
                String string = "CraftTweaker".equals(type) ? RecipeMakerItem.makeCraftTweakerCombinationRecipe(core) : RecipeMakerItem.makeDatapackCombinationRecipe(core, (DynamicOps<JsonElement>)ops);
                RecipeMakerItem.setClipboard(string);
                player.sendSystemMessage((Component)Localizable.of((String)"message.extendedcrafting.copied_recipe").build());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.isCrouching()) {
            ItemStack stack = player.getItemInHand(hand);
            RecipeMakerComponent component = (RecipeMakerComponent)stack.getOrDefault(ModDataComponentTypes.RECIPE_MAKER, (Object)RecipeMakerComponent.EMPTY);
            stack.set(ModDataComponentTypes.RECIPE_MAKER, (Object)component.flipShapeless());
            if (level.isClientSide()) {
                player.sendSystemMessage((Component)Localizable.of((String)"message.extendedcrafting.changed_mode").args(new Object[]{RecipeMakerItem.getModeString(stack)}).build());
            }
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)ModTooltips.TYPE.args(new Object[]{RecipeMakerItem.getType(stack)}).build());
        tooltip.add((Component)ModTooltips.MODE.args(new Object[]{RecipeMakerItem.getModeString(stack)}).build());
    }

    private static void setClipboard(String string) {
        Minecraft.getInstance().keyboardHandler.setClipboard(string);
    }

    private static String makeShapedCraftTweakerTableRecipe(IItemHandler inventory, TableType type) {
        StringBuilder string = new StringBuilder();
        UUID uuid = UUID.randomUUID();
        string.append("<recipetype:extendedcrafting:").append(type.type).append(">.addShaped(\"").append(uuid).append("\", ");
        if (type == TableType.TABLE) {
            string.append("0, ");
        }
        string.append("<>, [").append(NEW_LINE);
        int slots = RecipeMakerItem.getGridSlots(inventory);
        int sr = (int)Math.sqrt(slots);
        for (int i = 0; i < slots; ++i) {
            TagKey tagId;
            if (i == 0 || i % sr == 0) {
                string.append("[");
            }
            ItemStack stack = inventory.getStackInSlot(i);
            Object item = "";
            if (!stack.isEmpty() && ((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && (tagId = (TagKey)stack.getTags().findFirst().orElse(null)) != null) {
                item = "tag:items:" + String.valueOf(tagId.location());
            }
            if (((String)item).isEmpty()) {
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                item = "item:" + String.valueOf(id);
            }
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_DATA_COMPONENTS.get()).booleanValue() && !((String)item).startsWith("tag") && ModConfigs.isCraftTweakerInstalled()) {
                string.append(CraftTweakerUtils.getItemStackString(stack));
            } else {
                string.append("<").append((String)item).append(">");
            }
            if ((i + 1) % sr != 0) {
                string.append(", ");
            }
            if (i + 1 != sr && (i + 1) % sr != 0) continue;
            string.append("]");
            if (i + 1 < slots) {
                string.append(", ");
                string.append(NEW_LINE);
                continue;
            }
            string.append(System.lineSeparator());
        }
        if (type == TableType.FLUX_CRAFTER) {
            string.append("], 100000, ");
            string.append(ModConfigs.FLUX_CRAFTER_POWER_RATE.get());
            string.append(");");
        } else {
            string.append("]);");
        }
        return string.toString();
    }

    private static String makeShapelessCraftTweakerTableRecipe(IItemHandler inventory, TableType type) {
        StringBuilder string = new StringBuilder();
        UUID uuid = UUID.randomUUID();
        string.append("<recipetype:extendedcrafting:").append(type.type).append(">.addShapeless(\"").append(uuid).append("\", ");
        if (type == TableType.TABLE) {
            string.append("0, ");
        }
        string.append("<>, [").append(NEW_LINE);
        ArrayList<Integer> slotsWithItems = new ArrayList<Integer>();
        int slots = RecipeMakerItem.getGridSlots(inventory);
        int lastSlot = 0;
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            slotsWithItems.add(i);
            lastSlot = i;
        }
        Iterator iterator = slotsWithItems.iterator();
        while (iterator.hasNext()) {
            String item;
            int i = (Integer)iterator.next();
            ItemStack stack = inventory.getStackInSlot(i);
            TagKey tagId = stack.getTags().findFirst().orElse(null);
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && tagId != null) {
                item = "tag:items:" + String.valueOf(tagId);
            } else {
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                item = "item:" + String.valueOf(id);
            }
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_DATA_COMPONENTS.get()).booleanValue() && !item.startsWith("tag") && ModConfigs.isCraftTweakerInstalled()) {
                string.append(CraftTweakerUtils.getItemStackString(stack));
            } else {
                string.append("<").append(item).append(">");
            }
            if (i == lastSlot) continue;
            string.append(", ");
        }
        if (type == TableType.FLUX_CRAFTER) {
            string.append(System.lineSeparator());
            string.append("], 100000, ");
            string.append(ModConfigs.FLUX_CRAFTER_POWER_RATE.get());
            string.append(");");
        } else {
            string.append(System.lineSeparator()).append("]);");
        }
        return string.toString();
    }

    private static String makeCraftTweakerCombinationRecipe(CraftingCoreTileEntity tile) {
        StringBuilder string = new StringBuilder();
        UUID uuid = UUID.randomUUID();
        ResourceLocation inputId = BuiltInRegistries.ITEM.getKey((Object)tile.getInventory().getStackInSlot(0).getItem());
        string.append("<recipetype:extendedcrafting:combination>.addRecipe(\"").append(uuid).append("\", <>, 100000, <item:").append(inputId).append(">, [").append(NEW_LINE);
        ItemStack[] stacks = (ItemStack[])tile.getPedestalsWithItems().values().stream().filter(s -> !s.isEmpty()).toArray(ItemStack[]::new);
        for (int i = 0; i < stacks.length; ++i) {
            String item;
            ItemStack stack = stacks[i];
            TagKey tagId = stack.getTags().findFirst().orElse(null);
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && tagId != null) {
                item = "tag:items:" + String.valueOf(tagId);
            } else {
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                item = "item:" + String.valueOf(id);
            }
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_DATA_COMPONENTS.get()).booleanValue() && !item.startsWith("tag") && ModConfigs.isCraftTweakerInstalled()) {
                string.append(CraftTweakerUtils.getItemStackString(stack));
            } else {
                string.append("<").append(item).append(">");
            }
            if (i == stacks.length - 1) continue;
            string.append(", ");
        }
        string.append(System.lineSeparator()).append("]);");
        return string.toString();
    }

    private static String makeShapedDatapackTableRecipe(IItemHandler inventory, TableType type, DynamicOps<JsonElement> ops) {
        JsonObject object = new JsonObject();
        object.addProperty("type", type.shapedRecipeType);
        if (type == TableType.FLUX_CRAFTER) {
            object.addProperty("power_required", (Number)100000);
            object.addProperty("power_rate", (Number)ModConfigs.FLUX_CRAFTER_POWER_RATE.get());
        }
        LinkedHashMap<Ingredient, Character> keysMap = new LinkedHashMap<Ingredient, Character>();
        int slots = RecipeMakerItem.getGridSlots(inventory);
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.isEmpty() || keysMap.keySet().stream().anyMatch(ing -> ing.test(stack))) continue;
            TagKey tag = stack.getTags().findFirst().orElse(null);
            char key = KEYS[keysMap.size()];
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && tag != null) {
                keysMap.put(Ingredient.of((TagKey)tag), Character.valueOf(key));
            } else {
                DataComponentMap components = stack.getComponentsPatch().split().added().filter(Predicate.not(DataComponentType::isTransient));
                if (((Boolean)ModConfigs.RECIPE_MAKER_USE_DATA_COMPONENTS.get()).booleanValue() && !components.isEmpty()) {
                    keysMap.put(DataComponentIngredient.of((boolean)false, (DataComponentMap)components, (ItemLike[])new ItemLike[]{stack.getItem()}), Character.valueOf(key));
                } else {
                    keysMap.put(Ingredient.of((ItemStack[])new ItemStack[]{stack}), Character.valueOf(key));
                }
            }
            if (keysMap.size() < KEYS.length) continue;
            return "TOO MANY ITEMS";
        }
        JsonArray pattern = new JsonArray();
        int size = (int)Math.sqrt(slots);
        Set keys = keysMap.entrySet();
        for (int i = 0; i < size; ++i) {
            StringBuilder line = new StringBuilder();
            for (int j = 0; j < size; ++j) {
                ItemStack stack = inventory.getStackInSlot(i * size + j);
                Map.Entry entry = keys.stream().filter(e -> ((Ingredient)e.getKey()).test(stack)).findFirst().orElse(null);
                if (entry == null) {
                    line.append(" ");
                    continue;
                }
                line.append(entry.getValue());
            }
            pattern.add(line.toString());
        }
        object.add("pattern", (JsonElement)pattern);
        JsonObject key = new JsonObject();
        for (Map.Entry entry : keys) {
            key.add(((Character)entry.getValue()).toString(), (JsonElement)Ingredient.CODEC.encodeStart(ops, (Object)((Ingredient)entry.getKey())).getOrThrow());
        }
        object.add("key", (JsonElement)key);
        JsonObject result = new JsonObject();
        result.addProperty("id", "");
        object.add("result", (JsonElement)result);
        return GSON.toJson((JsonElement)object);
    }

    private static String makeShapelessDatapackTableRecipe(IItemHandler inventory, TableType type, DynamicOps<JsonElement> ops) {
        JsonObject object = new JsonObject();
        object.addProperty("type", type.shapelessRecipeType);
        if (type == TableType.FLUX_CRAFTER) {
            object.addProperty("power_required", (Number)100000);
            object.addProperty("power_rate", (Number)ModConfigs.FLUX_CRAFTER_POWER_RATE.get());
        }
        JsonArray ingredients = new JsonArray();
        int slots = RecipeMakerItem.getGridSlots(inventory);
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            TagKey tagId = stack.getTags().findFirst().orElse(null);
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && tagId != null) {
                JsonObject tag = new JsonObject();
                tag.addProperty("tag", tagId.toString());
                ingredients.add((JsonElement)tag);
                continue;
            }
            DataComponentMap components = stack.getComponentsPatch().split().added().filter(Predicate.not(DataComponentType::isTransient));
            Ingredient ingredient = (Boolean)ModConfigs.RECIPE_MAKER_USE_DATA_COMPONENTS.get() != false && !components.isEmpty() ? DataComponentIngredient.of((boolean)false, (DataComponentMap)components, (ItemLike[])new ItemLike[]{stack.getItem()}) : Ingredient.of((ItemStack[])new ItemStack[]{stack});
            ingredients.add((JsonElement)Ingredient.CODEC.encodeStart(ops, (Object)ingredient).getOrThrow());
        }
        object.add("ingredients", (JsonElement)ingredients);
        JsonObject result = new JsonObject();
        result.addProperty("id", "");
        object.add("result", (JsonElement)result);
        return GSON.toJson((JsonElement)object);
    }

    private static String makeDatapackCombinationRecipe(CraftingCoreTileEntity core, DynamicOps<JsonElement> ops) {
        ItemStack[] stacks;
        JsonObject object = new JsonObject();
        object.addProperty("type", "extendedcrafting:combination");
        object.addProperty("power_cost", (Number)100000);
        ItemStack stack = core.getInventory().getStackInSlot(0);
        ItemStack[] components = stack.getComponentsPatch().split().added().filter(Predicate.not(DataComponentType::isTransient));
        Ingredient ingredient = (Boolean)ModConfigs.RECIPE_MAKER_USE_DATA_COMPONENTS.get() != false && !components.isEmpty() ? DataComponentIngredient.of((boolean)false, (DataComponentMap)components, (ItemLike[])new ItemLike[]{stack.getItem()}) : Ingredient.of((ItemStack[])new ItemStack[]{stack});
        object.add("input", (JsonElement)Ingredient.CODEC.encodeStart(ops, (Object)ingredient).getOrThrow());
        JsonArray ingredients = new JsonArray();
        for (ItemStack stack2 : stacks = (ItemStack[])core.getPedestalsWithItems().values().stream().filter(s -> !s.isEmpty()).toArray(ItemStack[]::new)) {
            TagKey tagId = stack2.getTags().findFirst().orElse(null);
            if (((Boolean)ModConfigs.RECIPE_MAKER_USE_TAGS.get()).booleanValue() && tagId != null) {
                JsonObject tag = new JsonObject();
                tag.addProperty("tag", tagId.toString());
                ingredients.add((JsonElement)tag);
                continue;
            }
            DataComponentMap components2 = stack2.getComponentsPatch().split().added().filter(Predicate.not(DataComponentType::isTransient));
            Ingredient ingredient2 = (Boolean)ModConfigs.RECIPE_MAKER_USE_DATA_COMPONENTS.get() != false && !components2.isEmpty() ? DataComponentIngredient.of((boolean)false, (DataComponentMap)components2, (ItemLike[])new ItemLike[]{stack2.getItem()}) : Ingredient.of((ItemStack[])new ItemStack[]{stack2});
            ingredients.add((JsonElement)Ingredient.CODEC.encodeStart(ops, (Object)ingredient2).getOrThrow());
        }
        object.add("ingredients", (JsonElement)ingredients);
        JsonObject result = new JsonObject();
        result.addProperty("id", "");
        object.add("result", (JsonElement)result);
        return GSON.toJson((JsonElement)object);
    }

    private static boolean isTable(BlockEntity tile) {
        return tile instanceof BasicTableTileEntity || tile instanceof AdvancedTableTileEntity || tile instanceof EliteTableTileEntity || tile instanceof UltimateTableTileEntity || tile instanceof AutoTableTileEntity || tile instanceof EnderCrafterTileEntity || tile instanceof FluxCrafterTileEntity;
    }

    private static RecipeMakerComponent getComponent(ItemStack stack) {
        return (RecipeMakerComponent)stack.getOrDefault(ModDataComponentTypes.RECIPE_MAKER, (Object)RecipeMakerComponent.EMPTY);
    }

    private static String getType(ItemStack stack) {
        return RecipeMakerItem.getComponent(stack).type();
    }

    private static String getModeString(ItemStack stack) {
        return RecipeMakerItem.isShapeless(stack) ? "Shapeless" : "Shaped";
    }

    private static boolean isShapeless(ItemStack stack) {
        return RecipeMakerItem.getComponent(stack).shapeless();
    }

    private static int getGridSlots(IItemHandler inventory) {
        int slots = inventory.getSlots();
        if (slots >= 81) {
            return 81;
        }
        if (slots >= 49) {
            return 49;
        }
        if (slots >= 25) {
            return 25;
        }
        return 9;
    }

    private static enum TableType {
        TABLE("table", "extendedcrafting:shaped_table", "extendedcrafting:shapeless_table"),
        ENDER_CRAFTER("ender_crafting", "extendedcrafting:shaped_ender_crafter", "extendedcrafting:shapeless_ender_crafter"),
        FLUX_CRAFTER("flux_crafting", "extendedcrafting:shaped_flux_crafter", "extendedcrafting:shapeless_flux_crafter");

        public final String type;
        public final String shapedRecipeType;
        public final String shapelessRecipeType;

        private TableType(String type, String shapedRecipeType, String shapelessRecipeType) {
            this.type = type;
            this.shapedRecipeType = shapedRecipeType;
            this.shapelessRecipeType = shapelessRecipeType;
        }
    }
}

