/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei.category;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.api.crafting.IEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class EnderCrafterCategory
implements IRecipeCategory<RecipeHolder<IEnderCrafterRecipe>> {
    private static final ResourceLocation TEXTURE = ExtendedCrafting.resource("textures/jei/ender_crafting.png");
    public static final RecipeType<RecipeHolder<IEnderCrafterRecipe>> RECIPE_TYPE = RecipeType.createRecipeHolderType((ResourceLocation)ExtendedCrafting.resource("ender_crafting"));
    private final IDrawable background;
    private final IDrawableAnimated arrow;
    private final IDrawable icon;

    public EnderCrafterCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 116, 54);
        IDrawableStatic arrow = helper.createDrawable(TEXTURE, 195, 0, 24, 17);
        this.arrow = helper.createAnimatedDrawable(arrow, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.ENDER_CRAFTER.get()));
    }

    public RecipeType<RecipeHolder<IEnderCrafterRecipe>> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Localizable.of((String)"jei.category.extendedcrafting.ender_crafting").build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(RecipeHolder<IEnderCrafterRecipe> recipe, IRecipeSlotsView slots, GuiGraphics gfx, double mouseX, double mouseY) {
        this.arrow.draw(gfx, 61, 19);
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<IEnderCrafterRecipe> recipeHolder, IRecipeSlotsView slots, double mouseX, double mouseY) {
        IEnderCrafterRecipe recipe = (IEnderCrafterRecipe)recipeHolder.value();
        if (mouseX > 60.0 && mouseX < 83.0 && mouseY > 19.0 && mouseY < 34.0) {
            tooltip.add((FormattedText)ModTooltips.SECONDS.args(new Object[]{recipe.getCraftingTime()}).color(ChatFormatting.WHITE).build());
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<IEnderCrafterRecipe> recipeHolder, IFocusGroup focuses) {
        IEnderCrafterRecipe recipe = (IEnderCrafterRecipe)recipeHolder.value();
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        NonNullList inputs = recipe.getIngredients();
        ItemStack output = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        if (recipe instanceof ShapedEnderCrafterRecipe) {
            ShapedEnderCrafterRecipe shaped = (ShapedEnderCrafterRecipe)recipe;
            int stackIndex = 0;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 1, i * 18 + 1);
                    if (i >= shaped.getHeight() || j >= shaped.getWidth()) continue;
                    slot.addIngredients((Ingredient)inputs.get(stackIndex++));
                }
            }
        } else if (recipe instanceof ShapelessEnderCrafterRecipe) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int index = j + i * 3;
                    if (index >= inputs.size()) continue;
                    builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 1, i * 18 + 1).addIngredients((Ingredient)inputs.get(index));
                }
            }
            builder.setShapeless();
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addItemStack(output);
        builder.moveRecipeTransferButton(122, 41);
    }
}

