/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei.category;

import com.blakebr0.cucumber.util.Formatting;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.api.crafting.ICombinationRecipe;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import java.awt.Point;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class CombinationCraftingCategory
implements IRecipeCategory<RecipeHolder<ICombinationRecipe>> {
    private static final ResourceLocation TEXTURE = ExtendedCrafting.resource("textures/jei/combination_crafting.png");
    public static final RecipeType<RecipeHolder<ICombinationRecipe>> RECIPE_TYPE = RecipeType.createRecipeHolderType((ResourceLocation)ExtendedCrafting.resource("combination"));
    private final IDrawable background;
    private final IDrawable icon;

    public CombinationCraftingCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 140, 171);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.CRAFTING_CORE.get()));
    }

    public RecipeType<RecipeHolder<ICombinationRecipe>> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Localizable.of((String)"jei.category.extendedcrafting.combination").build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<ICombinationRecipe> recipeHolder, IRecipeSlotsView slots, double mouseX, double mouseY) {
        ICombinationRecipe recipe = (ICombinationRecipe)recipeHolder.value();
        if (mouseX > 1.0 && mouseX < 14.0 && mouseY > 9.0 && mouseY < 86.0) {
            tooltip.add((FormattedText)Formatting.energy((Object)recipe.getPowerCost()));
            tooltip.add((FormattedText)Formatting.energyPerTick((Object)recipe.getPowerRate()));
        }
        if (mouseX > 5.0 && mouseX < 23.0 && mouseY > 144.0 && mouseY < 165.0) {
            tooltip.addAll(recipe.getInputsList());
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<ICombinationRecipe> recipeHolder, IFocusGroup focuses) {
        ICombinationRecipe recipe = (ICombinationRecipe)recipeHolder.value();
        ClientLevel level = Minecraft.getInstance().level;
        assert (level != null);
        NonNullList inputs = recipe.getIngredients();
        ItemStack output = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        builder.addSlot(RecipeIngredientRole.INPUT, 77, 47).addIngredients(recipe.getInput());
        double angleBetweenEach = 360.0 / (double)inputs.size();
        Point point = new Point(53, 8);
        Point center = new Point(74, 47);
        for (Ingredient input : inputs) {
            builder.addSlot(RecipeIngredientRole.INPUT, point.x, point.y).addIngredients(input);
            point = CombinationCraftingCategory.rotatePoint(point, center, angleBetweenEach);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 77, 150).addItemStack(output);
    }

    private static Point rotatePoint(Point in, Point about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.x - about.x) - Math.sin(rad) * (double)(in.y - about.y) + (double)about.x;
        double newY = Math.sin(rad) * (double)(in.x - about.x) + Math.cos(rad) * (double)(in.y - about.y) + (double)about.y;
        return new Point((int)newX, (int)newY);
    }
}

