/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part;

import java.util.Optional;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.NetworkCapability;
import org.cyclops.integrateddynamics.api.part.PartCapability;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.EnergyHelpers;
import org.cyclops.integratedtunnels.Capabilities;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.core.part.IPartTypeInterfacePositionedAddon;
import org.cyclops.integratedtunnels.core.part.PartTypeInterfacePositionedAddon;

public class PartTypeInterfaceEnergy
extends PartTypeInterfacePositionedAddon<IEnergyNetwork, IEnergyStorage, PartTypeInterfaceEnergy, State> {
    public PartTypeInterfaceEnergy(String name) {
        super(name);
    }

    @Override
    public NetworkCapability<IEnergyNetwork> getNetworkCapability() {
        return Capabilities.EnergyNetwork.NETWORK;
    }

    @Override
    public PartCapability<IEnergyStorage> getPartCapability() {
        return Capabilities.EnergyStorage.PART;
    }

    @Override
    public BlockCapability<IEnergyStorage, Direction> getBlockCapability() {
        return Capabilities.EnergyStorage.BLOCK;
    }

    @Override
    public Optional<IEnergyStorage> getTargetCapabilityInstance(PartPos pos) {
        return EnergyHelpers.getEnergyStorage((PartPos)pos);
    }

    protected State constructDefaultState() {
        return new State();
    }

    public int getConsumptionRate(State state) {
        return GeneralConfig.interfaceEnergyBaseConsumption;
    }

    public static class State
    extends PartTypeInterfacePositionedAddon.State<IEnergyNetwork, IEnergyStorage, PartTypeInterfaceEnergy, State> {
        @Override
        public PartCapability<IEnergyStorage> getTargetCapability() {
            return Capabilities.EnergyStorage.PART;
        }

        @Override
        public IEnergyStorage getCapabilityInstance() {
            return new EnergyStorage(this);
        }
    }

    public static class EnergyStorage
    implements IEnergyStorage {
        private final IPartTypeInterfacePositionedAddon.IState<IEnergyNetwork, IEnergyStorage, ?, ?> state;

        public EnergyStorage(IPartTypeInterfacePositionedAddon.IState<IEnergyNetwork, IEnergyStorage, ?, ?> state) {
            this.state = state;
        }

        protected IEnergyStorage getEnergyStorage() {
            return (IEnergyStorage)this.state.getPositionedAddonsNetwork().getChannelExternal(Capabilities.EnergyStorage.BLOCK, this.state.getChannel());
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.state.isNetworkAndPositionValid()) {
                return 0;
            }
            this.state.disablePosition();
            int ret = this.getEnergyStorage().receiveEnergy(maxReceive, simulate);
            this.state.enablePosition();
            return ret;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.state.isNetworkAndPositionValid()) {
                return 0;
            }
            this.state.disablePosition();
            int ret = this.getEnergyStorage().extractEnergy(maxExtract, simulate);
            this.state.enablePosition();
            return ret;
        }

        public int getEnergyStored() {
            if (!this.state.isNetworkAndPositionValid()) {
                return 0;
            }
            this.state.disablePosition();
            int ret = this.getEnergyStorage().getEnergyStored();
            this.state.enablePosition();
            return ret;
        }

        public int getMaxEnergyStored() {
            if (!this.state.isNetworkAndPositionValid()) {
                return 0;
            }
            this.state.disablePosition();
            int ret = this.getEnergyStorage().getMaxEnergyStored();
            this.state.enablePosition();
            return ret;
        }

        public boolean canExtract() {
            if (!this.state.isNetworkAndPositionValid()) {
                return false;
            }
            this.state.disablePosition();
            boolean ret = this.getEnergyStorage().canExtract();
            this.state.enablePosition();
            return ret;
        }

        public boolean canReceive() {
            if (!this.state.isNetworkAndPositionValid()) {
                return false;
            }
            this.state.disablePosition();
            boolean ret = this.getEnergyStorage().canReceive();
            this.state.enablePosition();
            return ret;
        }
    }
}

