/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.blockentity.BlockEntityDryingBasin;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integratedtunnels.part.PartTypes;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspects;

@GameTestHolder(value="integratedtunnels")
@PrefixGameTestTemplate(value=false)
public class GameTestsWorldFluid {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final int TIMEOUT = 2000;
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testWorldFluidImporterToInterfaceToExporterBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_WORLD_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_WORLD_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH, (IPartType)PartTypes.EXPORTER_WORLD_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_WORLD_FLUID.getItem()));
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.west(), Blocks.WATER);
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.World.FLUID_BOOLEAN_IMPORT, (ItemStack)variableAspect);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH), TunnelAspects.Write.World.FLUID_BOOLEAN_EXPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent(Blocks.WATER, POS.west());
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east());
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)0, "Basin contains fluid");
            helper.assertBlockPresent(Blocks.WATER, POS.east().north());
        });
    }

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testWorldFluidImporterToInterfaceToExporterBlockCorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_WORLD_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_WORLD_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH, (IPartType)PartTypes.EXPORTER_WORLD_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_WORLD_FLUID.getItem()));
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.west(), Blocks.WATER);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.World.FLUID_FLUIDSTACK_IMPORT, (ItemStack)GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_FLUIDSTACK, (IValue)ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.WATER, 10))));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH), TunnelAspects.Write.World.FLUID_FLUIDSTACK_EXPORT, (ItemStack)GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_FLUIDSTACK, (IValue)ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.WATER, 10))));
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent(Blocks.WATER, POS.west());
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east());
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)0, "Basin contains fluid");
            helper.assertBlockPresent(Blocks.WATER, POS.east().north());
        });
    }

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testWorldFluidImporterToInterfaceToExporterBlockIncorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_WORLD_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_WORLD_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH, (IPartType)PartTypes.EXPORTER_WORLD_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_WORLD_FLUID.getItem()));
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.west(), Blocks.WATER);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.World.FLUID_FLUIDSTACK_IMPORT, (ItemStack)GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_FLUIDSTACK, (IValue)ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.LAVA, 10))));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH), TunnelAspects.Write.World.FLUID_FLUIDSTACK_EXPORT, (ItemStack)GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_FLUIDSTACK, (IValue)ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.LAVA, 10))));
        helper.succeedWhen(() -> {
            helper.assertBlockPresent(Blocks.WATER, POS.west());
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east());
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)0, "Basin contains fluid");
            helper.assertBlockNotPresent(Blocks.WATER, POS.east().north());
        });
    }
}

