/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;
import org.cyclops.integratedtunnels.GeneralConfig;

public class ItemHandlerWorldEntityImportWrapper
implements IIngredientComponentStorage<ItemStack, Integer> {
    private final ServerLevel world;
    private final BlockPos pos;
    private final Direction facing;
    private final List<ItemEntity> entities;

    public ItemHandlerWorldEntityImportWrapper(ServerLevel world, BlockPos pos, Direction facing, boolean ignorePickupDelay) {
        this(world, pos, facing, new AABB(pos), ignorePickupDelay);
    }

    public ItemHandlerWorldEntityImportWrapper(ServerLevel world, BlockPos pos, Direction facing, AABB area, boolean ignorePickupDelay) {
        this.world = world;
        this.pos = pos;
        this.facing = facing;
        this.entities = world.getEntitiesOfClass(ItemEntity.class, area, input -> (ignorePickupDelay || !input.hasPickUpDelay()) && input.isAlive());
    }

    public List<ItemEntity> getEntities() {
        return this.entities;
    }

    public IngredientComponent<ItemStack, Integer> getComponent() {
        return IngredientComponent.ITEMSTACK;
    }

    public Iterator<ItemStack> iterator() {
        return this.entities.stream().map(ItemEntity::getItem).iterator();
    }

    public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchCondition) {
        return new FilteredIngredientCollectionIterator((Iterable)((Object)this), this.getComponent().getMatcher(), (Object)prototype, (Object)matchCondition);
    }

    public long getMaxQuantity() {
        return 64 * this.entities.size();
    }

    public ItemStack insert(@Nonnull ItemStack ingredient, boolean simulate) {
        return ItemStack.EMPTY;
    }

    protected void postExtract(ItemEntity entity, ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            entity.remove(Entity.RemovalReason.DISCARDED);
        } else {
            entity.setItem(itemStack);
        }
        if (GeneralConfig.worldInteractionEvents) {
            this.world.levelEvent(1000, this.pos, 0);
            this.world.levelEvent(2000, this.pos.relative(this.facing.getOpposite()), this.facing.get3DDataValue());
        }
    }

    public ItemStack extract(@Nonnull ItemStack prototype, Integer matchCondition, boolean simulate) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        Integer quantityFlag = (Integer)this.getComponent().getPrimaryQuantifier().getMatchCondition();
        Integer subMatchCondition = (Integer)matcher.withoutCondition((Object)matchCondition, (Object)((Integer)this.getComponent().getPrimaryQuantifier().getMatchCondition()));
        List<ItemEntity> entities = this.entities;
        if (entities.isEmpty()) {
            return ItemStack.EMPTY;
        }
        for (ItemEntity entity : entities) {
            ItemStack itemStack = entity.getItem();
            if (!matcher.matches((Object)prototype, (Object)itemStack, (Object)subMatchCondition) || matcher.hasCondition((Object)matchCondition, (Object)quantityFlag) && itemStack.getCount() < prototype.getCount()) continue;
            itemStack = itemStack.copy();
            ItemStack ret = itemStack.split(Helpers.castSafe((long)prototype.getCount()));
            if (!simulate) {
                this.postExtract(entity, itemStack);
            }
            return ret;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack extract(long maxQuantity, boolean simulate) {
        if (this.entities.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemEntity entity = this.entities.get(0);
        ItemStack itemStack = entity.getItem();
        itemStack = itemStack.copy();
        ItemStack ret = itemStack.split(Helpers.castSafe((long)maxQuantity));
        if (!simulate) {
            this.postExtract(entity, itemStack);
        }
        return ret;
    }
}

