/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.init;

import codechicken.multipart.api.MultipartClientRegistry;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.render.PartRenderer;
import codechicken.translocators.client.gui.GuiTranslocator;
import codechicken.translocators.client.render.FluidTranslocatorPartRenderer;
import codechicken.translocators.client.render.ItemTranslocatorPartRenderer;
import codechicken.translocators.client.render.TileCraftingGridRenderer;
import codechicken.translocators.handler.CraftingGridKeyHandler;
import codechicken.translocators.init.TranslocatorTextures;
import codechicken.translocators.init.TranslocatorsModContent;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class ClientInit {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");

    public static void init(IEventBus modBus) {
        LOCK.lock();
        modBus.addListener(ClientInit::clientSetup);
        modBus.addListener(ClientInit::onRegisterMenuScreens);
        modBus.addListener(ClientInit::registerRenderers);
        CraftingGridKeyHandler.init(modBus);
        TranslocatorTextures.init(modBus);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        MultipartClientRegistry.register((MultipartType)((MultipartType)TranslocatorsModContent.itemTranslocatorPartType.get()), (PartRenderer)new ItemTranslocatorPartRenderer());
        MultipartClientRegistry.register((MultipartType)((MultipartType)TranslocatorsModContent.fluidTranslocatorPartType.get()), (PartRenderer)new FluidTranslocatorPartRenderer());
    }

    private static void onRegisterMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)TranslocatorsModContent.containerItemTranslocator.get(), GuiTranslocator::new);
    }

    private static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)TranslocatorsModContent.tileCraftingGridType.get(), TileCraftingGridRenderer::new);
    }
}

