/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.container;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.inventory.InventorySimple;
import codechicken.lib.inventory.container.ContainerExtended;
import codechicken.lib.inventory.container.SlotDummy;
import codechicken.lib.packet.PacketCustom;
import codechicken.translocators.init.TranslocatorsModContent;
import codechicken.translocators.network.TranslocatorNetwork;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerItemTranslocator
extends ContainerExtended {
    public ContainerItemTranslocator(int windowId, Inventory playerInv, MCDataInput packet) {
        this(windowId, playerInv, new InventorySimple(9, packet.readUShort()));
    }

    public ContainerItemTranslocator(int windowId, Inventory playerInv, InventorySimple inv) {
        super((MenuType)TranslocatorsModContent.containerItemTranslocator.get(), windowId, playerInv);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                this.addSlot((Slot)new SlotDummy((Container)inv, y + x * 3, 62 + y * 18, 17 + x * 18, inv.limit));
            }
        }
        this.bindPlayerInventory(playerInv);
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return !(slot instanceof SlotDummy);
    }

    public void sendLargeStack(ItemStack stack, int slot, ServerPlayer player) {
        PacketCustom packet = new PacketCustom(TranslocatorNetwork.NET_CHANNEL, 1, player.registryAccess());
        packet.writeByte(slot);
        packet.writeItemStack(stack);
        packet.sendToPlayer(player);
    }
}

