/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.index.Term;
import org.apache.lucene.ars_nouveau.index.TermStates;
import org.apache.lucene.ars_nouveau.queries.spans.SpanCollector;
import org.apache.lucene.ars_nouveau.queries.spans.SpanDisiPriorityQueue;
import org.apache.lucene.ars_nouveau.queries.spans.SpanDisiWrapper;
import org.apache.lucene.ars_nouveau.queries.spans.SpanDisjunctionDISIApproximation;
import org.apache.lucene.ars_nouveau.queries.spans.SpanPositionQueue;
import org.apache.lucene.ars_nouveau.queries.spans.SpanQuery;
import org.apache.lucene.ars_nouveau.queries.spans.SpanWeight;
import org.apache.lucene.ars_nouveau.queries.spans.Spans;
import org.apache.lucene.ars_nouveau.search.BooleanClause;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.QueryVisitor;
import org.apache.lucene.ars_nouveau.search.ScoreMode;
import org.apache.lucene.ars_nouveau.search.TwoPhaseIterator;
import org.apache.lucene.ars_nouveau.search.Weight;

public final class SpanOrQuery
extends SpanQuery {
    private List<SpanQuery> clauses;
    private String field;

    public SpanOrQuery(SpanQuery ... clauses) {
        this.clauses = new ArrayList<SpanQuery>(clauses.length);
        for (SpanQuery seq : clauses) {
            this.addClause(seq);
        }
    }

    private final void addClause(SpanQuery clause) {
        if (this.field == null) {
            this.field = clause.getField();
        } else if (clause.getField() != null && !clause.getField().equals(this.field)) {
            throw new IllegalArgumentException("Clauses must have same field.");
        }
        this.clauses.add(clause);
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        SpanOrQuery rewritten = new SpanOrQuery(new SpanQuery[0]);
        boolean actuallyRewritten = false;
        for (int i = 0; i < this.clauses.size(); ++i) {
            SpanQuery c = this.clauses.get(i);
            SpanQuery query = (SpanQuery)c.rewrite(indexSearcher);
            actuallyRewritten |= query != c;
            rewritten.addClause(query);
        }
        if (actuallyRewritten) {
            return rewritten;
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (!visitor.acceptField(this.getField())) {
            return;
        }
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.SHOULD, this);
        for (SpanQuery q : this.clauses) {
            q.visit(v);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("spanOr([");
        Iterator<SpanQuery> i = this.clauses.iterator();
        while (i.hasNext()) {
            SpanQuery clause = i.next();
            buffer.append(clause.toString(field));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("])");
        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.clauses.equals(((SpanOrQuery)other).clauses);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.clauses.hashCode();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        ArrayList<SpanWeight> subWeights = new ArrayList<SpanWeight>(this.clauses.size());
        for (SpanQuery q : this.clauses) {
            subWeights.add(q.createWeight(searcher, scoreMode, boost));
        }
        return new SpanOrWeight(searcher, scoreMode.needsScores() ? SpanOrQuery.getTermStates(subWeights) : null, subWeights, boost);
    }

    public class SpanOrWeight
    extends SpanWeight {
        final List<SpanWeight> subWeights;

        public SpanOrWeight(IndexSearcher searcher, Map<Term, TermStates> terms, List<SpanWeight> subWeights, float boost) throws IOException {
            super(SpanOrQuery.this, searcher, terms, boost);
            this.subWeights = subWeights;
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            for (Weight weight : this.subWeights) {
                if (weight.isCacheable(ctx)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void extractTermStates(Map<Term, TermStates> contexts) {
            for (SpanWeight w : this.subWeights) {
                w.extractTermStates(contexts);
            }
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            final ArrayList<Spans> subSpans = new ArrayList<Spans>(SpanOrQuery.this.clauses.size());
            for (SpanWeight spanWeight : this.subWeights) {
                Spans spans = spanWeight.getSpans(context, requiredPostings);
                if (spans == null) continue;
                subSpans.add(spans);
            }
            if (subSpans.size() == 0) {
                return null;
            }
            if (subSpans.size() == 1) {
                return (Spans)subSpans.get(0);
            }
            final SpanDisiPriorityQueue byDocQueue = new SpanDisiPriorityQueue(subSpans.size());
            for (Spans spans : subSpans) {
                byDocQueue.add(new SpanDisiWrapper(spans));
            }
            final SpanPositionQueue spanPositionQueue = new SpanPositionQueue(subSpans.size());
            return new Spans(){
                Spans topPositionSpans = null;
                float positionsCost = -1.0f;
                int lastDocTwoPhaseMatched = -1;
                long cost = -1L;

                @Override
                public int nextDoc() throws IOException {
                    this.topPositionSpans = null;
                    SpanDisiWrapper topDocSpans = byDocQueue.top();
                    int currentDoc = topDocSpans.doc;
                    do {
                        topDocSpans.doc = topDocSpans.iterator.nextDoc();
                        topDocSpans = byDocQueue.updateTop();
                    } while (topDocSpans.doc == currentDoc);
                    return topDocSpans.doc;
                }

                @Override
                public int advance(int target) throws IOException {
                    this.topPositionSpans = null;
                    SpanDisiWrapper topDocSpans = byDocQueue.top();
                    do {
                        topDocSpans.doc = topDocSpans.iterator.advance(target);
                        topDocSpans = byDocQueue.updateTop();
                    } while (topDocSpans.doc < target);
                    return topDocSpans.doc;
                }

                @Override
                public int docID() {
                    SpanDisiWrapper topDocSpans = byDocQueue.top();
                    return topDocSpans.doc;
                }

                @Override
                public TwoPhaseIterator asTwoPhaseIterator() {
                    float sumMatchCost = 0.0f;
                    long sumApproxCost = 0L;
                    for (SpanDisiWrapper w : byDocQueue) {
                        if (w.twoPhaseView == null) continue;
                        long costWeight = w.cost <= 1L ? 1L : w.cost;
                        sumMatchCost += w.twoPhaseView.matchCost() * (float)costWeight;
                        sumApproxCost += costWeight;
                    }
                    if (sumApproxCost == 0L) {
                        this.computePositionsCost();
                        return null;
                    }
                    final float matchCost = sumMatchCost / (float)sumApproxCost;
                    return new TwoPhaseIterator(new SpanDisjunctionDISIApproximation(byDocQueue)){

                        @Override
                        public boolean matches() throws IOException {
                            return this.twoPhaseCurrentDocMatches();
                        }

                        @Override
                        public float matchCost() {
                            return matchCost;
                        }
                    };
                }

                void computePositionsCost() {
                    float sumPositionsCost = 0.0f;
                    long sumCost = 0L;
                    for (SpanDisiWrapper w : byDocQueue) {
                        long costWeight = w.cost <= 1L ? 1L : w.cost;
                        sumPositionsCost += w.spans.positionsCost() * (float)costWeight;
                        sumCost += costWeight;
                    }
                    this.positionsCost = sumPositionsCost / (float)sumCost;
                }

                @Override
                public float positionsCost() {
                    assert (this.positionsCost > 0.0f);
                    return this.positionsCost;
                }

                boolean twoPhaseCurrentDocMatches() throws IOException {
                    SpanDisiWrapper listAtCurrentDoc = byDocQueue.topList();
                    int currentDoc = listAtCurrentDoc.doc;
                    while (listAtCurrentDoc.twoPhaseView != null) {
                        if (listAtCurrentDoc.twoPhaseView.matches()) {
                            listAtCurrentDoc.lastApproxMatchDoc = currentDoc;
                            break;
                        }
                        listAtCurrentDoc.lastApproxNonMatchDoc = currentDoc;
                        listAtCurrentDoc = listAtCurrentDoc.next;
                        if (listAtCurrentDoc != null) continue;
                        return false;
                    }
                    this.lastDocTwoPhaseMatched = currentDoc;
                    this.topPositionSpans = null;
                    return true;
                }

                void fillPositionQueue() throws IOException {
                    assert (spanPositionQueue.size() == 0);
                    SpanDisiWrapper listAtCurrentDoc = byDocQueue.topList();
                    while (listAtCurrentDoc != null) {
                        Spans spansAtDoc = listAtCurrentDoc.spans;
                        if (this.lastDocTwoPhaseMatched == listAtCurrentDoc.doc && listAtCurrentDoc.twoPhaseView != null) {
                            if (listAtCurrentDoc.lastApproxNonMatchDoc == listAtCurrentDoc.doc) {
                                spansAtDoc = null;
                            } else if (listAtCurrentDoc.lastApproxMatchDoc != listAtCurrentDoc.doc && !listAtCurrentDoc.twoPhaseView.matches()) {
                                spansAtDoc = null;
                            }
                        }
                        if (spansAtDoc != null) {
                            assert (spansAtDoc.docID() == listAtCurrentDoc.doc);
                            assert (spansAtDoc.startPosition() == -1);
                            spansAtDoc.nextStartPosition();
                            assert (spansAtDoc.startPosition() != Integer.MAX_VALUE);
                            spanPositionQueue.add(spansAtDoc);
                        }
                        listAtCurrentDoc = listAtCurrentDoc.next;
                    }
                    assert (spanPositionQueue.size() > 0);
                }

                @Override
                public int nextStartPosition() throws IOException {
                    if (this.topPositionSpans == null) {
                        spanPositionQueue.clear();
                        this.fillPositionQueue();
                        this.topPositionSpans = (Spans)spanPositionQueue.top();
                    } else {
                        this.topPositionSpans.nextStartPosition();
                        this.topPositionSpans = (Spans)spanPositionQueue.updateTop();
                    }
                    return this.topPositionSpans.startPosition();
                }

                @Override
                public int startPosition() {
                    return this.topPositionSpans == null ? -1 : this.topPositionSpans.startPosition();
                }

                @Override
                public int endPosition() {
                    return this.topPositionSpans == null ? -1 : this.topPositionSpans.endPosition();
                }

                @Override
                public int width() {
                    return this.topPositionSpans.width();
                }

                @Override
                public void collect(SpanCollector collector) throws IOException {
                    if (this.topPositionSpans != null) {
                        this.topPositionSpans.collect(collector);
                    }
                }

                @Override
                public String toString() {
                    return "spanOr(" + String.valueOf(SpanOrQuery.this) + ")@" + this.docID() + ": " + this.startPosition() + " - " + this.endPosition();
                }

                @Override
                public long cost() {
                    if (this.cost == -1L) {
                        this.cost = 0L;
                        for (Spans spans : subSpans) {
                            this.cost += spans.cost();
                        }
                    }
                    return this.cost;
                }
            };
        }
    }
}

