/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.document;

import org.apache.lucene.ars_nouveau.document.Field;
import org.apache.lucene.ars_nouveau.document.FieldType;
import org.apache.lucene.ars_nouveau.document.IntPoint;
import org.apache.lucene.ars_nouveau.document.SortedNumericDocValuesField;
import org.apache.lucene.ars_nouveau.document.StoredValue;
import org.apache.lucene.ars_nouveau.index.DocValuesType;
import org.apache.lucene.ars_nouveau.search.IndexOrDocValuesQuery;
import org.apache.lucene.ars_nouveau.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.ars_nouveau.search.PointRangeQuery;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.SortField;
import org.apache.lucene.ars_nouveau.search.SortedNumericSelector;
import org.apache.lucene.ars_nouveau.search.SortedNumericSortField;
import org.apache.lucene.ars_nouveau.util.BytesRef;
import org.apache.lucene.ars_nouveau.util.NumericUtils;

public final class IntField
extends Field {
    private static final FieldType FIELD_TYPE = new FieldType();
    private static final FieldType FIELD_TYPE_STORED;
    private final StoredValue storedValue;

    public IntField(String name, int value, Field.Store stored) {
        super(name, stored == Field.Store.YES ? FIELD_TYPE_STORED : FIELD_TYPE);
        this.fieldsData = value;
        this.storedValue = stored == Field.Store.YES ? new StoredValue(value) : null;
    }

    @Override
    public BytesRef binaryValue() {
        byte[] bytes = new byte[4];
        NumericUtils.intToSortableBytes((Integer)this.fieldsData, bytes, 0);
        return new BytesRef(bytes);
    }

    @Override
    public StoredValue storedValue() {
        return this.storedValue;
    }

    @Override
    public void setIntValue(int value) {
        super.setIntValue(value);
        if (this.storedValue != null) {
            this.storedValue.setIntValue(value);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " <" + this.name + ":" + String.valueOf(this.fieldsData) + ">";
    }

    public static Query newExactQuery(String field, int value) {
        return IntField.newRangeQuery(field, value, value);
    }

    public static Query newRangeQuery(String field, int lowerValue, int upperValue) {
        PointRangeQuery.checkArgs(field, lowerValue, upperValue);
        IndexOrDocValuesQuery fallbackQuery = new IndexOrDocValuesQuery(IntPoint.newRangeQuery(field, lowerValue, upperValue), SortedNumericDocValuesField.newSlowRangeQuery(field, lowerValue, upperValue));
        return new IndexSortSortedNumericDocValuesRangeQuery(field, lowerValue, upperValue, fallbackQuery);
    }

    public static Query newSetQuery(String field, int ... values) {
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        long[] points = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            points[i] = values[i];
        }
        return new IndexOrDocValuesQuery(IntPoint.newSetQuery(field, (int[])values.clone()), SortedNumericDocValuesField.newSlowSetQuery(field, points));
    }

    public static SortField newSortField(String field, boolean reverse, SortedNumericSelector.Type selector) {
        return new SortedNumericSortField(field, SortField.Type.INT, reverse, selector);
    }

    static {
        FIELD_TYPE.setDimensions(1, 4);
        FIELD_TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        FIELD_TYPE.freeze();
        FIELD_TYPE_STORED = new FieldType(FIELD_TYPE);
        FIELD_TYPE_STORED.setStored(true);
        FIELD_TYPE_STORED.freeze();
    }
}

