/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.synonym.word2vec;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.ars_nouveau.analysis.synonym.word2vec.TermAndBoost;
import org.apache.lucene.ars_nouveau.analysis.synonym.word2vec.Word2VecModel;
import org.apache.lucene.ars_nouveau.codecs.hnsw.DefaultFlatVectorScorer;
import org.apache.lucene.ars_nouveau.index.KnnVectorValues;
import org.apache.lucene.ars_nouveau.index.VectorSimilarityFunction;
import org.apache.lucene.ars_nouveau.search.KnnCollector;
import org.apache.lucene.ars_nouveau.search.TopDocs;
import org.apache.lucene.ars_nouveau.util.BytesRef;
import org.apache.lucene.ars_nouveau.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.ars_nouveau.util.hnsw.HnswGraphSearcher;
import org.apache.lucene.ars_nouveau.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.ars_nouveau.util.hnsw.RandomVectorScorer;
import org.apache.lucene.ars_nouveau.util.hnsw.RandomVectorScorerSupplier;

public class Word2VecSynonymProvider {
    private static final VectorSimilarityFunction SIMILARITY_FUNCTION = VectorSimilarityFunction.DOT_PRODUCT;
    private final Word2VecModel word2VecModel;
    private final OnHeapHnswGraph hnswGraph;
    private final DefaultFlatVectorScorer defaultFlatVectorScorer = new DefaultFlatVectorScorer();

    public Word2VecSynonymProvider(Word2VecModel model) throws IOException {
        this.word2VecModel = model;
        RandomVectorScorerSupplier scorerSupplier = this.defaultFlatVectorScorer.getRandomVectorScorerSupplier(SIMILARITY_FUNCTION, this.word2VecModel);
        HnswGraphBuilder builder = HnswGraphBuilder.create(scorerSupplier, 16, 100, HnswGraphBuilder.randSeed, this.word2VecModel.size());
        this.hnswGraph = builder.build(this.word2VecModel.size());
    }

    public List<TermAndBoost> getSynonyms(BytesRef term, int maxSynonymsPerTerm, float minAcceptedSimilarity) throws IOException {
        if (term == null) {
            throw new IllegalArgumentException("Term must not be null");
        }
        LinkedList<TermAndBoost> result = new LinkedList<TermAndBoost>();
        float[] query = this.word2VecModel.vectorValue(term);
        if (query != null) {
            RandomVectorScorer scorer = this.defaultFlatVectorScorer.getRandomVectorScorer(SIMILARITY_FUNCTION, (KnnVectorValues)this.word2VecModel, query);
            KnnCollector synonyms = HnswGraphSearcher.search(scorer, maxSynonymsPerTerm + 1, this.hnswGraph, null, Integer.MAX_VALUE);
            TopDocs topDocs = synonyms.topDocs();
            for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                float similarity = topDocs.scoreDocs[i].score;
                int id = topDocs.scoreDocs[i].doc;
                BytesRef synonym = this.word2VecModel.termValue(id);
                if (synonym.equals(term) || !(similarity >= minAcceptedSimilarity)) continue;
                result.addLast(new TermAndBoost(synonym, similarity));
            }
        }
        return result;
    }
}

