/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.ars_nouveau.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.ars_nouveau.internal.hppc.IntArrayList;
import org.apache.lucene.ars_nouveau.internal.hppc.IntCursor;
import org.apache.lucene.ars_nouveau.internal.hppc.IntIntHashMap;
import org.apache.lucene.ars_nouveau.util.automaton.Automaton;
import org.apache.lucene.ars_nouveau.util.automaton.Transition;

public class AutomatonToTokenStream {
    private AutomatonToTokenStream() {
    }

    public static TokenStream toTokenStream(Automaton automaton) {
        ArrayList<IntArrayList> positionNodes = new ArrayList<IntArrayList>();
        Transition[][] transitions = automaton.getSortedTransitions();
        int[] indegree = new int[transitions.length];
        for (int i = 0; i < transitions.length; ++i) {
            for (int edge = 0; edge < transitions[i].length; ++edge) {
                int n = transitions[i][edge].dest;
                indegree[n] = indegree[n] + 1;
            }
        }
        if (indegree[0] != 0) {
            throw new IllegalArgumentException("Start node has incoming edges, creating cycle");
        }
        LinkedList<RemapNode> noIncomingEdges = new LinkedList<RemapNode>();
        IntIntHashMap idToPos = new IntIntHashMap();
        noIncomingEdges.addLast(new RemapNode(0, 0));
        while (!noIncomingEdges.isEmpty()) {
            RemapNode currState = (RemapNode)noIncomingEdges.removeFirst();
            for (int i = 0; i < transitions[currState.id].length; ++i) {
                int n = transitions[currState.id][i].dest;
                indegree[n] = indegree[n] - 1;
                if (indegree[transitions[currState.id][i].dest] != 0) continue;
                noIncomingEdges.addLast(new RemapNode(transitions[currState.id][i].dest, currState.pos + 1));
            }
            if (positionNodes.size() == currState.pos) {
                IntArrayList posIncs = new IntArrayList();
                posIncs.add(currState.id);
                positionNodes.add(posIncs);
            } else {
                ((IntArrayList)positionNodes.get(currState.pos)).add(currState.id);
            }
            idToPos.put(currState.id, currState.pos);
        }
        for (int i = 0; i < indegree.length; ++i) {
            if (indegree[i] == 0) continue;
            throw new IllegalArgumentException("Cycle found in automaton");
        }
        ArrayList<List<EdgeToken>> edgesByLayer = new ArrayList<List<EdgeToken>>();
        for (IntArrayList layer : positionNodes) {
            ArrayList<EdgeToken> edges = new ArrayList<EdgeToken>();
            for (IntCursor state : layer) {
                for (Transition t : transitions[state.value]) {
                    for (int val = t.min; val <= t.max; ++val) {
                        int destLayer = idToPos.get(t.dest);
                        edges.add(new EdgeToken(destLayer, val));
                        if (!automaton.isAccept(t.dest) || destLayer == positionNodes.size() - 1) continue;
                        edges.add(new EdgeToken(positionNodes.size() - 1, val));
                    }
                }
            }
            edgesByLayer.add(edges);
        }
        return new TopoTokenStream(edgesByLayer);
    }

    private record RemapNode(int id, int pos) {
    }

    private record EdgeToken(int destination, int value) {
    }

    private static class TopoTokenStream
    extends TokenStream {
        private final List<List<EdgeToken>> edgesByPos;
        private int currentPos;
        private int currentEdgeIndex;
        private CharTermAttribute charAttr = this.addAttribute(CharTermAttribute.class);
        private PositionIncrementAttribute incAttr = this.addAttribute(PositionIncrementAttribute.class);
        private PositionLengthAttribute lenAttr = this.addAttribute(PositionLengthAttribute.class);
        private OffsetAttribute offAttr = this.addAttribute(OffsetAttribute.class);

        public TopoTokenStream(List<List<EdgeToken>> edgesByPos) {
            this.edgesByPos = edgesByPos;
        }

        @Override
        public boolean incrementToken() throws IOException {
            this.clearAttributes();
            while (this.currentPos < this.edgesByPos.size() && this.currentEdgeIndex == this.edgesByPos.get(this.currentPos).size()) {
                this.currentEdgeIndex = 0;
                ++this.currentPos;
            }
            if (this.currentPos == this.edgesByPos.size()) {
                return false;
            }
            EdgeToken currentEdge = this.edgesByPos.get(this.currentPos).get(this.currentEdgeIndex);
            this.charAttr.append((char)currentEdge.value);
            this.incAttr.setPositionIncrement(this.currentEdgeIndex == 0 ? 1 : 0);
            this.lenAttr.setPositionLength(currentEdge.destination - this.currentPos);
            this.offAttr.setOffset(this.currentPos, currentEdge.destination);
            ++this.currentEdgeIndex;
            return true;
        }

        @Override
        public void reset() throws IOException {
            super.reset();
            this.clearAttributes();
            this.currentPos = 0;
            this.currentEdgeIndex = 0;
        }

        @Override
        public void end() throws IOException {
            this.clearAttributes();
            this.incAttr.setPositionIncrement(0);
            this.offAttr.setOffset(this.edgesByPos.size() - 1, this.edgesByPos.size() - 1);
        }
    }
}

