/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ritual.ConjureBiomeRitual;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ConjureDesertRitual
extends ConjureBiomeRitual {
    public ConjureDesertRitual() {
        super((ResourceKey<Biome>)Biomes.DESERT);
    }

    @Override
    public void onStart(@Nullable Player player) {
        super.onStart(player);
        if (this.getConsumedItems().stream().anyMatch(i -> i.is(ItemTags.TERRACOTTA))) {
            this.biome = Biomes.BADLANDS;
        }
    }

    @Override
    public BlockState stateForPos(BlockPos placePos) {
        boolean isBadlands = this.getConsumedItems().stream().anyMatch(i -> i.is(ItemTags.TERRACOTTA));
        if (isBadlands) {
            int depth = this.getPos().getY() - placePos.getY();
            if (depth == 1) {
                return Blocks.RED_SAND.defaultBlockState();
            }
            if (depth == 2) {
                return Blocks.ORANGE_TERRACOTTA.defaultBlockState();
            }
            if (depth == 3 || depth == 4) {
                return Blocks.RED_TERRACOTTA.defaultBlockState();
            }
            return Blocks.TERRACOTTA.defaultBlockState();
        }
        return placePos.getY() == this.getPos().getY() - 1 ? Blocks.SAND.defaultBlockState() : Blocks.SANDSTONE.defaultBlockState();
    }

    @Override
    public String getLangName() {
        return "Conjure Island: Desert";
    }

    @Override
    public String getLangDescription() {
        return "Creates an island of sand and sandstone in a circle around the ritual, converting the area to Desert. The island will generate with a radius of 7 blocks. Augmenting the ritual with Source Gems will increase the radius by 1 for each gem. Source must be provided nearby as blocks are generated. Augmenting with Terracotta will create Badlands instead.";
    }

    @Override
    public boolean canConsumeItem(ItemStack stack) {
        boolean isBadlands = this.getConsumedItems().stream().anyMatch(i -> i.is(ItemTags.TERRACOTTA));
        return super.canConsumeItem(stack) || !isBadlands && stack.is(ItemTags.TERRACOTTA);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix(RitualLib.DESERT);
    }

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag tag) {
        super.read(provider, tag);
        boolean isBadlands = this.getConsumedItems().stream().anyMatch(i -> i.is(ItemTags.TERRACOTTA));
        if (isBadlands) {
            this.biome = Biomes.BADLANDS;
        }
    }
}

