/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mob_jar;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.api.util.LevelPosMap;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="ars_nouveau")
public class WitherBehavior
extends JarBehavior<WitherBoss> {
    public static LevelPosMap WITHER_MAP = new LevelPosMap((level, pos) -> {
        MobJarTile mobJarTile;
        BlockEntity patt0$temp = level.getBlockEntity(pos);
        return !(patt0$temp instanceof MobJarTile) || !((mobJarTile = (MobJarTile)patt0$temp).getEntity() instanceof WitherBoss);
    });

    @Override
    public void tick(MobJarTile tile) {
        Level level = tile.getLevel();
        if (level == null) {
            return;
        }
        if (level.getGameTime() % 20L == 0L) {
            WITHER_MAP.addPosition(level, tile.getBlockPos());
        }
    }

    @Override
    public void onRedstonePower(MobJarTile tile) {
        this.destroyBlocks(tile);
    }

    private void destroyBlocks(MobJarTile tile) {
        BlockPos pos = tile.getBlockPos();
        WitherBoss entity = (WitherBoss)this.entityFromJar(tile);
        if (!EventHooks.canEntityGrief((Level)tile.getLevel(), (Entity)entity)) {
            return;
        }
        for (BlockPos block : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
            BlockState bs;
            if (block.equals((Object)pos) || !(bs = tile.getLevel().getBlockState(block)).canEntityDestroy((BlockGetter)tile.getLevel(), block, (Entity)entity) || !EventHooks.onEntityDestroyBlock((LivingEntity)entity, (BlockPos)block, (BlockState)bs)) continue;
            tile.getLevel().destroyBlock(block, true, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void livingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.level();
        if (level.isClientSide() || entity instanceof IDispellable || entity instanceof ISummon) {
            return;
        }
        WITHER_MAP.applyForRange(level, entity.blockPosition(), 4.0, arg_0 -> WitherBehavior.lambda$livingDeath$1(level, (Entity)entity, arg_0));
    }

    private static /* synthetic */ Boolean lambda$livingDeath$1(Level level, Entity entity, BlockPos pos) {
        MobJarTile tile;
        BlockEntity patt0$temp = level.getBlockEntity(pos);
        if (patt0$temp instanceof MobJarTile && (tile = (MobJarTile)patt0$temp).getEntity() instanceof WitherBoss) {
            ItemStack rose = new ItemStack((ItemLike)Items.WITHER_ROSE);
            BlockPos blockPos = entity.blockPosition();
            level.addFreshEntity((Entity)new ItemEntity(level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), rose));
            return true;
        }
        return false;
    }
}

