/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mob_jar;

import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.hollingsworth.arsnouveau.common.entity.EntityDummy;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DecoyBehavior
extends JarBehavior<EntityDummy> {
    @Override
    public void tick(MobJarTile tile) {
        super.tick(tile);
        if (!((Boolean)tile.getBlockState().getValue((Property)BlockStateProperties.POWERED)).booleanValue()) {
            return;
        }
        Level level = tile.getLevel();
        if (level == null) {
            return;
        }
        if (level.isClientSide) {
            return;
        }
        BlockPos pos = tile.getBlockPos();
        EntityDummy dummy = (EntityDummy)this.entityFromJar(tile);
        for (Mob entity : level.getEntitiesOfClass(Mob.class, new AABB(pos).inflate(10.0))) {
            Vec3 vec3d = new Vec3((double)pos.getX() - entity.getX(), (double)pos.getY() - entity.getY(), (double)pos.getZ() - entity.getZ());
            if (vec3d.length() < 1.0) continue;
            entity.setDeltaMovement(entity.getDeltaMovement().add(vec3d.normalize()).scale((double)0.2f));
            entity.hurtMarked = true;
        }
    }
}

