/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.light.provider;

import com.hollingsworth.arsnouveau.common.light.LambDynamicLightsInitializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import net.minecraft.util.Brightness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public record StarbuncleEntityLuminance(int trigger, int luminance) implements EntityLuminance
{
    public static final MapCodec<StarbuncleEntityLuminance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Brightness.LIGHT_VALUE_CODEC.fieldOf("trigger").forGetter(StarbuncleEntityLuminance::trigger), (App)Brightness.LIGHT_VALUE_CODEC.fieldOf("luminance").forGetter(StarbuncleEntityLuminance::luminance)).apply((Applicative)instance, StarbuncleEntityLuminance::new));

    @NotNull
    public EntityLuminance.Type type() {
        return LambDynamicLightsInitializer.STARBUNCLE;
    }

    public @Range(from=0L, to=15L) int getLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull Entity entity) {
        if (entity.level().getBrightness(LightLayer.BLOCK, entity.blockPosition()) < this.trigger) {
            return this.luminance;
        }
        return 0;
    }
}

