/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.data;

import com.hollingsworth.arsnouveau.api.item.NBTComponent;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public class ItemScrollData
implements NBTComponent<ItemScrollData>,
TooltipProvider {
    public static final Codec<ItemScrollData> CODEC = ItemStack.CODEC.listOf().xmap(ItemScrollData::new, i -> i.items);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemScrollData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.LIST_STREAM_CODEC, i -> i.items, ItemScrollData::new);
    private final List<ItemStack> items;

    public ItemScrollData(List<ItemStack> items) {
        this.items = List.copyOf(items);
    }

    public ItemScrollData() {
        this(List.of());
    }

    public boolean containsStack(ItemStack stack) {
        return ItemScrollData.contains(this.items, stack);
    }

    public static boolean contains(List<ItemStack> list, ItemStack stack) {
        return list.stream().anyMatch(s -> ItemStack.isSameItem((ItemStack)s, (ItemStack)stack));
    }

    public Iterable<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public Codec<ItemScrollData> getCodec() {
        return CODEC;
    }

    public Mutable mutable() {
        return new Mutable(this);
    }

    public void addToTooltip(Item.TooltipContext pContext, Consumer<Component> pTooltipAdder, TooltipFlag pTooltipFlag) {
        for (ItemStack s : this.items) {
            pTooltipAdder.accept(s.getHoverName());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemScrollData that = (ItemScrollData)o;
        return ItemStack.listMatches(this.items, that.items);
    }

    public int hashCode() {
        return Objects.hashCode(this.getItems());
    }

    public static class Mutable {
        private final List<ItemStack> list;

        public Mutable(ItemScrollData data) {
            this.list = data.items.stream().map(ItemStack::copy).collect(Collectors.toCollection(ArrayList::new));
        }

        public boolean add(ItemStack stack) {
            return this.list.add(stack.copy());
        }

        public boolean remove(ItemStack stack) {
            this.list.removeIf(stored -> ItemStack.isSameItem((ItemStack)stored, (ItemStack)stack));
            for (int i = 0; i < this.list.size(); ++i) {
                if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)this.list.get(i))) continue;
                this.list.remove(i);
                return true;
            }
            return false;
        }

        public List<ItemStack> getItems() {
            return this.list;
        }

        public ItemScrollData toImmutable() {
            return new ItemScrollData(this.list);
        }

        public boolean writeWithFeedback(Player player, ItemStack stackToWrite) {
            if (stackToWrite.isEmpty()) {
                return false;
            }
            if (ItemScrollData.contains(this.list, stackToWrite)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.scribe.item_removed"));
                return this.remove(stackToWrite);
            }
            if (this.add(stackToWrite)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.scribe.item_added"));
                return true;
            }
            return false;
        }
    }
}

