/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.mana.IManaDiscountEquipment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.client.gui.SpellTooltip;
import com.hollingsworth.arsnouveau.client.renderer.item.SpellBowRenderer;
import com.hollingsworth.arsnouveau.common.entity.EntitySpellArrow;
import com.hollingsworth.arsnouveau.common.items.SpellArrow;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.util.HolderHelper;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SpellBow
extends BowItem
implements GeoItem,
ICasterTool,
IManaDiscountEquipment {
    public AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SpellBow(Item.Properties properties) {
        super(properties);
    }

    public SpellBow() {
        this(ItemsRegistry.defaultItemProperties().stacksTo(1).component(DataComponents.BASE_COLOR, (Object)DyeColor.PURPLE).component(DataComponentRegistry.SPELL_CASTER, (Object)new SpellCaster()));
    }

    public boolean canPlayerCastSpell(ItemStack bow, Player playerentity) {
        AbstractCaster caster = this.getSpellCaster(bow);
        return new SpellResolver(new SpellContext(playerentity.level, caster.getSpell(), (LivingEntity)playerentity, new PlayerCaster(playerentity), bow)).withSilent(true).canCast((LivingEntity)playerentity);
    }

    public ItemStack findAmmo(Player playerEntity, ItemStack shootable) {
        Item item = shootable.getItem();
        if (!(item instanceof ProjectileWeaponItem)) {
            return ItemStack.EMPTY;
        }
        ProjectileWeaponItem projectileWeaponItem = (ProjectileWeaponItem)item;
        Predicate<ItemStack> predicate = projectileWeaponItem.getSupportedHeldProjectiles().and(i -> !(i.getItem() instanceof SpellArrow) || i.getItem() instanceof SpellArrow && this.canPlayerCastSpell(shootable, playerEntity));
        ItemStack itemstack = ProjectileWeaponItem.getHeldProjectile((LivingEntity)playerEntity, predicate);
        if (!itemstack.isEmpty()) {
            return CommonHooks.getProjectile((LivingEntity)playerEntity, (ItemStack)shootable, (ItemStack)itemstack);
        }
        predicate = projectileWeaponItem.getAllSupportedProjectiles().and(i -> !(i.getItem() instanceof SpellArrow) || i.getItem() instanceof SpellArrow && this.canPlayerCastSpell(shootable, playerEntity));
        for (int i2 = 0; i2 < playerEntity.getInventory().getContainerSize(); ++i2) {
            ItemStack itemstack1 = playerEntity.inventory.getItem(i2);
            if (!predicate.test(itemstack1)) continue;
            return CommonHooks.getProjectile((LivingEntity)playerEntity, (ItemStack)shootable, (ItemStack)itemstack1);
        }
        return CommonHooks.getProjectile((LivingEntity)playerEntity, (ItemStack)shootable, (ItemStack)(playerEntity.hasInfiniteMaterials() ? new ItemStack((ItemLike)Items.ARROW) : ItemStack.EMPTY));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        AbstractCaster caster = this.getSpellCaster(playerIn.getItemInHand(handIn));
        boolean hasAmmo = !this.findAmmo(playerIn, itemstack).isEmpty();
        InteractionResultHolder ret = EventHooks.onArrowNock((ItemStack)itemstack, (Level)worldIn, (Player)playerIn, (InteractionHand)handIn, (boolean)hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (hasAmmo || caster.getSpell().isValid() && new SpellResolver(new SpellContext(worldIn, caster.getSpell(), (LivingEntity)playerIn, new PlayerCaster(playerIn), itemstack)).withSilent(true).canCast((LivingEntity)playerIn)) {
            playerIn.startUsingItem(handIn);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        if (!playerIn.hasInfiniteMaterials() && !hasAmmo) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        playerIn.startUsingItem(handIn);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public EntitySpellArrow buildSpellArrow(Level worldIn, Player playerentity, AbstractCaster<?> caster, boolean isSpellArrow, ItemStack bowStack, ItemStack arrowStack) {
        EntitySpellArrow spellArrow = new EntitySpellArrow(worldIn, (LivingEntity)playerentity, arrowStack, bowStack);
        spellArrow.setResolver(new SpellResolver(new SpellContext(worldIn, caster.getSpell(), (LivingEntity)playerentity, new PlayerCaster(playerentity), bowStack)).withSilent(true));
        if (isSpellArrow) {
            spellArrow.setBaseDamage(0.0);
        }
        return spellArrow;
    }

    public void releaseUsing(@NotNull ItemStack bowStack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof Player)) {
            return;
        }
        Player playerentity = (Player)entityLiving;
        boolean isInfinity = playerentity.hasInfiniteMaterials() || bowStack.getEnchantmentLevel(HolderHelper.unwrap(worldIn, Enchantments.INFINITY)) > 0;
        ItemStack arrowStack = this.findAmmo(playerentity, bowStack);
        int useTime = this.getUseDuration(bowStack, entityLiving) - timeLeft;
        useTime = EventHooks.onArrowLoose((ItemStack)bowStack, (Level)worldIn, (Player)playerentity, (int)useTime, (!arrowStack.isEmpty() || isInfinity ? 1 : 0) != 0);
        if (useTime < 0) {
            return;
        }
        boolean canFire = false;
        if (!arrowStack.isEmpty() || isInfinity) {
            if (arrowStack.isEmpty()) {
                arrowStack = new ItemStack((ItemLike)Items.ARROW);
            }
            canFire = true;
        }
        AbstractCaster caster = this.getSpellCaster(bowStack);
        boolean isSpellArrow = false;
        if (arrowStack.isEmpty() && caster.getSpell().isValid() && new SpellResolver(new SpellContext(worldIn, caster.getSpell(), (LivingEntity)playerentity, new PlayerCaster(playerentity), bowStack)).canCast((LivingEntity)playerentity)) {
            canFire = true;
            isSpellArrow = true;
        }
        if (!canFire) {
            return;
        }
        float f = SpellBow.getPowerForTime((int)useTime);
        boolean didCastSpell = false;
        if ((double)f >= 0.1) {
            ArrowItem arrowItem;
            Item item;
            boolean isArrowInfinite;
            boolean bl = isArrowInfinite = playerentity.hasInfiniteMaterials() || (item = arrowStack.getItem()) instanceof ArrowItem && (arrowItem = (ArrowItem)item).isInfinite(arrowStack, bowStack, (LivingEntity)playerentity);
            if (!worldIn.isClientSide) {
                int use = EnchantmentHelper.processAmmoUse((ServerLevel)((ServerLevel)worldIn), (ItemStack)bowStack, (ItemStack)arrowStack, (int)1);
                ArrowItem arrowitem = (ArrowItem)(arrowStack.getItem() instanceof ArrowItem ? arrowStack.getItem() : Items.ARROW);
                Object abstractarrowentity = arrowitem.createArrow(worldIn, arrowStack, (LivingEntity)playerentity, bowStack);
                abstractarrowentity = this.customArrow((AbstractArrow)abstractarrowentity, arrowStack, bowStack);
                ArrayList<Object> arrows = new ArrayList<Object>();
                SpellResolver resolver = new SpellResolver(new SpellContext(worldIn, caster.modifySpellBeforeCasting((ServerLevel)worldIn, (Entity)entityLiving, InteractionHand.MAIN_HAND, caster.getSpell()), (LivingEntity)playerentity, new PlayerCaster(playerentity), bowStack));
                if (arrowitem instanceof SpellArrow) {
                    if (!resolver.canCast((LivingEntity)playerentity)) {
                        return;
                    }
                    if (resolver.canCast((LivingEntity)playerentity)) {
                        resolver.expendMana();
                        didCastSpell = true;
                    }
                } else if (resolver.withSilent(true).canCast((LivingEntity)playerentity)) {
                    abstractarrowentity = this.buildSpellArrow(worldIn, playerentity, caster, isSpellArrow, bowStack, arrowStack);
                    resolver.expendMana();
                    didCastSpell = true;
                }
                arrows.add(abstractarrowentity);
                if (caster.getSpell().isValid() && didCastSpell) {
                    int numSplits = caster.getSpell().getBuffsAtIndex(0, (LivingEntity)playerentity, AugmentSplit.INSTANCE);
                    if (abstractarrowentity instanceof EntitySpellArrow) {
                        EntitySpellArrow arrow = (EntitySpellArrow)((Object)abstractarrowentity);
                        numSplits = arrow.resolver().spell.getBuffsAtIndex(0, (LivingEntity)playerentity, AugmentSplit.INSTANCE);
                    }
                    for (int i = 0; i < numSplits; ++i) {
                        EntitySpellArrow spellArrow = this.buildSpellArrow(worldIn, playerentity, caster, isSpellArrow, bowStack, arrowStack);
                        arrows.add((Object)spellArrow);
                    }
                }
                int opposite = -1;
                int counter = 0;
                for (AbstractArrow abstractArrow : arrows) {
                    abstractArrow.shootFromRotation((Entity)playerentity, playerentity.getXRot(), playerentity.getYRot() + (float)(Math.round((double)counter / 2.0) * 10L * (long)opposite), 0.0f, f * 3.0f, 1.0f);
                    opposite *= -1;
                    ++counter;
                    if (f >= 1.0f) {
                        abstractArrow.setCritArrow(true);
                    }
                    if (use == 0) {
                        arrowStack = arrowStack.copyWithCount(1);
                        arrowStack.set(DataComponents.INTANGIBLE_PROJECTILE, (Object)Unit.INSTANCE);
                    }
                    this.addArrow(abstractArrow, bowStack, arrowStack, use == 0, playerentity);
                }
                if (!isArrowInfinite && !playerentity.hasInfiniteMaterials()) {
                    arrowStack.shrink(use);
                }
            }
            worldIn.playSound(null, playerentity.getX(), playerentity.getY(), playerentity.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (worldIn.random.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        }
    }

    public void addArrow(AbstractArrow abstractarrowentity, ItemStack bowStack, ItemStack arrowStack, boolean isArrowInfinite, Player playerentity) {
        int power = bowStack.getEnchantmentLevel(HolderHelper.unwrap(playerentity.level, Enchantments.POWER));
        if (power > 0) {
            abstractarrowentity.setBaseDamage(abstractarrowentity.getBaseDamage() + (double)power * 0.5 + 0.5);
        }
        if (bowStack.getEnchantmentLevel(HolderHelper.unwrap(playerentity.level, Enchantments.FLAME)) > 0) {
            abstractarrowentity.setRemainingFireTicks(100);
        }
        if (isArrowInfinite || playerentity.hasInfiniteMaterials() && (arrowStack.getItem() == Items.SPECTRAL_ARROW || arrowStack.getItem() == Items.TIPPED_ARROW)) {
            abstractarrowentity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        playerentity.level.addFreshEntity((Entity)abstractarrowentity);
    }

    @NotNull
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return super.getAllSupportedProjectiles().or(i -> i.getItem() instanceof SpellArrow);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        if (Screen.hasShiftDown() || !((Boolean)Config.GLYPH_TOOLTIPS.get()).booleanValue()) {
            this.getInformation(stack, context, tooltip2, flagIn);
        }
        super.appendHoverText(stack, context, tooltip2, flagIn);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        AbstractCaster caster = this.getSpellCaster(pStack);
        if (caster != null && ((Boolean)Config.GLYPH_TOOLTIPS.get()).booleanValue() && !Screen.hasShiftDown() && !caster.isSpellHidden() && !caster.getSpell().isEmpty()) {
            return Optional.of(new SpellTooltip(caster));
        }
        return Optional.empty();
    }

    @Override
    public boolean isScribedSpellValid(AbstractCaster<?> caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        return spell.unsafeList().stream().noneMatch(s -> s instanceof AbstractCastMethod);
    }

    @Override
    public void sendInvalidMessage(Player player) {
        PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"ars_nouveau.bow.invalid"));
    }

    @Override
    public void scribeModifiedSpell(AbstractCaster<?> caster, Player player, InteractionHand hand, ItemStack stack, Spell.Mutable spell) {
        ArrayList<AbstractSpellPart> recipe = new ArrayList<AbstractSpellPart>();
        recipe.add(MethodProjectile.INSTANCE);
        recipe.addAll(spell.recipe);
        spell.recipe = recipe;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return true;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private final BlockEntityWithoutLevelRenderer renderer = new SpellBowRenderer();

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                return this.renderer;
            }
        });
    }

    @Override
    public int getManaDiscount(ItemStack i, Spell spell) {
        return MethodProjectile.INSTANCE.getCastingCost();
    }
}

