/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.chimera;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.WildenChimera;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.EventHooks;

public class ChimeraRamGoal
extends Goal {
    WildenChimera boss;
    int timeCharging;
    boolean finished;
    boolean startedCharge;
    boolean isCharging;
    boolean hasHit;

    public ChimeraRamGoal(WildenChimera boss) {
        this.boss = boss;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        super.start();
        this.timeCharging = 0;
        this.finished = false;
        this.startedCharge = false;
        this.isCharging = false;
        this.hasHit = false;
        this.boss.isRamGoal = true;
    }

    public void tick() {
        super.tick();
        if (this.timeCharging >= 65) {
            this.endRam();
        }
        if (this.boss.getTarget() == null) {
            this.endRam();
        }
        if (!this.startedCharge) {
            this.boss.setRamPrep(true);
            this.startedCharge = true;
        }
        ++this.timeCharging;
        if (this.timeCharging <= 25 && !this.isCharging) {
            LivingEntity livingentity = this.boss.getTarget();
            if (livingentity != null) {
                this.boss.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
            }
            this.boss.getNavigation().stop();
        }
        if (this.timeCharging > 25 && !this.isCharging) {
            this.isCharging = true;
            this.boss.setRamPrep(false);
            this.boss.setRamming(true);
        }
        if (this.isCharging) {
            if (this.boss.getNavigation() == null || this.boss.getTarget() == null) {
                this.attack();
                return;
            }
            this.breakBlocks();
            Path path = this.boss.getNavigation().createPath(this.boss.getTarget().blockPosition().above(), 1);
            if (path == null) {
                return;
            }
            this.boss.getNavigation().moveTo(path, 1.5);
            this.attack();
        }
        if (this.boss != null && this.boss.getTarget() != null && this.hasHit && BlockUtil.distanceFrom(this.boss.position, this.boss.getTarget().position) <= 3.0) {
            this.endRam();
        }
    }

    public void breakBlocks() {
        if (!EventHooks.canEntityGrief((Level)this.boss.level, (Entity)this.boss)) {
            return;
        }
        Direction facing = this.boss.getDirection();
        BlockPos facingPos = this.boss.blockPosition().above().relative(facing);
        for (int i = 0; i < 3; ++i) {
            facingPos = facingPos.above(i);
            this.destroyBlock(facingPos.above());
            this.destroyBlock(facingPos.east());
            this.destroyBlock(facingPos.west());
            this.destroyBlock(facingPos.south());
            this.destroyBlock(facingPos.north());
        }
    }

    public void destroyBlock(BlockPos pos) {
        if (SpellUtil.isCorrectHarvestLevel(4, this.boss.level.getBlockState(pos))) {
            this.boss.level.destroyBlock(pos, true);
        }
    }

    public void stop() {
        super.stop();
        this.boss.isRamGoal = false;
        this.boss.setRamming(false);
        this.boss.setRamPrep(false);
    }

    public void endRam() {
        this.finished = true;
        this.boss.ramCooldown = (int)(400.0 + ParticleUtil.inRange(-100.0, 100 + this.boss.getCooldownModifier()));
        this.boss.isRamGoal = false;
        this.attack();
        this.boss.setRamming(false);
        this.boss.setRamPrep(false);
    }

    protected void attack() {
        List nearbyEntities = this.boss.level.getEntitiesOfClass(LivingEntity.class, new AABB(this.boss.blockPosition()).inflate(3.0, 3.0, 3.0));
        for (LivingEntity enemy : nearbyEntities) {
            if (enemy.equals((Object)this.boss)) continue;
            this.boss.doHurtTarget((Entity)enemy);
            enemy.knockback(3.0, (double)Mth.sin((float)(this.boss.yRot * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.boss.yRot * ((float)Math.PI / 180)))));
            this.hasHit = true;
        }
    }

    public boolean canContinueToUse() {
        boolean canContinue;
        boolean bl = canContinue = !this.finished && !this.boss.getPhaseSwapping();
        if (!canContinue) {
            this.boss.setRamming(false);
            this.boss.setRamPrep(false);
            this.boss.isRamGoal = false;
        }
        return canContinue;
    }

    public boolean canUse() {
        return this.boss.getTarget() != null && this.boss.ramCooldown <= 0 && this.boss.canRam(false);
    }
}

