/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.common.block.tile.BasicSpellTurretTile;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectRedstone;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class TimerSpellTurretTile
extends BasicSpellTurretTile
implements IWandable {
    private int ticksPerSignal = 20;
    public boolean isLocked;
    public boolean isOff;
    public int ticksElapsed;

    public TimerSpellTurretTile(BlockEntityType<?> p_i48289_1_, BlockPos pos, BlockState state) {
        super(p_i48289_1_, pos, state);
    }

    public TimerSpellTurretTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.TIMER_SPELL_TURRET_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        ++this.ticksElapsed;
        if (!this.level.isClientSide && this.ticksPerSignal > 0 && !this.isOff && this.ticksElapsed >= this.ticksPerSignal) {
            this.getBlockState().tick((ServerLevel)this.level, this.getBlockPos(), this.getLevel().random);
            this.ticksElapsed = 0;
        }
    }

    @Override
    public int getManaCost() {
        int cost = super.getManaCost();
        Spell spell = this.spellCaster.getSpell();
        cost -= spell.getInstanceCount(MethodTouch.INSTANCE) * MethodTouch.INSTANCE.getCastingCost();
        cost -= spell.getInstanceCount(EffectRedstone.INSTANCE) * EffectRedstone.INSTANCE.getCastingCost();
        cost -= spell.getInstanceCount(MethodProjectile.INSTANCE) * MethodProjectile.INSTANCE.getCastingCost();
        return Math.max(0, cost -= spell.getInstanceCount(AugmentSensitive.INSTANCE) * AugmentSensitive.INSTANCE.getCastingCost());
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        super.registerControllers(data);
        data.add(new AnimationController((GeoAnimatable)this, "spinController", 0, this::spinPredicate));
    }

    public PlayState spinPredicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("key_rotation"));
        return PlayState.CONTINUE;
    }

    @Override
    public void onWanded(Player playerEntity) {
        this.isLocked = !this.isLocked;
        this.updateBlock();
    }

    public void addTime(int ticks) {
        this.ticksPerSignal += ticks;
        this.ticksPerSignal = Math.max(0, this.ticksPerSignal);
        this.ticksElapsed = 0;
        this.updateBlock();
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        super.getTooltip(tooltip);
        if (this.ticksPerSignal <= 0 && !this.isOff) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.tooltip.turned_off"));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.seconds", (Object[])new Object[]{this.ticksPerSignal / 20}));
        }
        if (this.isOff) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.tooltip.turned_off"));
        }
        if (this.isLocked) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.locked"));
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.isLocked = tag.getBoolean("locked");
        this.ticksPerSignal = tag.getInt("time");
        this.isOff = tag.getBoolean("off");
        this.ticksElapsed = tag.getInt("ticksElapsed");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putBoolean("locked", this.isLocked);
        tag.putInt("time", this.ticksPerSignal);
        tag.putBoolean("off", this.isOff);
        tag.putInt("ticksElapsed", this.ticksElapsed);
    }
}

