/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ScryerCrystalTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ScryerCrystal
extends TickableModBlock {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing");
    public static final BooleanProperty BEING_VIEWED = BooleanProperty.create((String)"being_viewed");
    public static VoxelShape SOUTH = ScryerCrystal.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)1.0);
    public static VoxelShape NORTH = ScryerCrystal.box((double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0, (double)16.0);
    public static VoxelShape EAST = ScryerCrystal.box((double)0.0, (double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0);
    public static VoxelShape WEST = ScryerCrystal.box((double)15.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    public static VoxelShape UP = ScryerCrystal.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
    public static VoxelShape DOWN = ScryerCrystal.box((double)5.0, (double)15.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public ScryerCrystal(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)BEING_VIEWED, (Comparable)Boolean.valueOf(false)));
    }

    public ScryerCrystal() {
        this(ScryerCrystal.defaultProperties().noOcclusion());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, BEING_VIEWED});
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.getValue((Property)FACING) == Direction.SOUTH) {
            return SOUTH;
        }
        if (pState.getValue((Property)FACING) == Direction.NORTH) {
            return NORTH;
        }
        if (pState.getValue((Property)FACING) == Direction.EAST) {
            return EAST;
        }
        if (pState.getValue((Property)FACING) == Direction.WEST) {
            return WEST;
        }
        if (pState.getValue((Property)FACING) == Direction.UP) {
            return UP;
        }
        if (pState.getValue((Property)FACING) == Direction.DOWN) {
            return DOWN;
        }
        return EAST;
    }

    public static Position getDispensePosition(BlockPos pos, Direction direction) {
        double negOffset = -0.49;
        double d0 = (double)pos.getX() + 0.5 + negOffset * (double)direction.getStepX();
        double d1 = (double)pos.getY() + 0.5 + negOffset * (double)direction.getStepY();
        double d2 = (double)pos.getZ() + 0.5 + negOffset * (double)direction.getStepZ();
        return new Vec3(d0, d1, d2);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ScryerCrystalTile(pPos, pState);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof ScryerCrystalTile) {
            ScryerCrystalTile scryerCrystalTile = (ScryerCrystalTile)blockEntity;
            if (pPlayer.getItemInHand(pHand).isEmpty() & pHand == InteractionHand.MAIN_HAND) {
                scryerCrystalTile.mountCamera(pLevel, pPos, pPlayer);
            }
        }
        return super.useItemOn(stack, pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof ScryerCrystalTile) {
            ScryerCrystalTile scryerCrystalTile = (ScryerCrystalTile)blockEntity;
            return scryerCrystalTile.playersViewing;
        }
        return 0;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getClickedFace());
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }
}

