/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations.properties;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.documentation.DocPlayerData;
import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.ListParticleWidgetProvider;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleConfigWidgetProvider;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.ColorProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.PropMap;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.SoundProperty;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.client.gui.documentation.DocEntryButton;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.registry.ModParticles;
import com.hollingsworth.arsnouveau.setup.registry.SoundRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ParticleTypeProperty
extends BaseProperty<ParticleTypeProperty> {
    public static final Map<ParticleType<? extends PropertyParticleOptions>, ParticleData> PARTICLE_TYPES = new ConcurrentHashMap<ParticleType<? extends PropertyParticleOptions>, ParticleData>();
    public static MapCodec<ParticleTypeProperty> CODEC = ParticleTypeProperty.buildCodec(ParticleTypeProperty::new);
    public static StreamCodec<RegistryFriendlyByteBuf, ParticleTypeProperty> STREAM_CODEC = ParticleTypeProperty.buildStreamCodec(ParticleTypeProperty::new);
    protected ParticleData selectedData;
    protected PropMap subProperties;
    protected ParticleType<? extends PropertyParticleOptions> type;

    public static void addType(ParticleData data) {
        PARTICLE_TYPES.put(data.type, data);
    }

    protected static <T extends ParticleTypeProperty> MapCodec<T> buildCodec(BiFunction<ParticleType<?>, PropMap, T> constructor) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.PARTICLE_TYPE.byNameCodec().fieldOf("particleType").forGetter(i -> i.type), (App)PropMap.CODEC.fieldOf("subProperties").forGetter(i -> i.subProperties)).apply((Applicative)instance, constructor));
    }

    protected static <T extends ParticleTypeProperty> StreamCodec<RegistryFriendlyByteBuf, T> buildStreamCodec(BiFunction<ParticleType<?>, PropMap, T> constructor) {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)BuiltInRegistries.PARTICLE_TYPE.key()), ParticleTypeProperty::type, PropMap.STREAM_CODEC, i -> i.subProperties, constructor);
    }

    public ParticleTypeProperty() {
        this((ParticleType)ModParticles.NEW_GLOW_TYPE.get(), new PropMap());
    }

    public ParticleTypeProperty(ParticleType<?> type, PropMap subProperties) {
        this.subProperties = subProperties;
        this.type = type;
        this.selectedData = PARTICLE_TYPES.get(type);
        if (this.selectedData == null) {
            System.out.println("UNREGISTERED PARTICLE TYPE FOR " + String.valueOf(type));
            System.out.println(BuiltInRegistries.PARTICLE_TYPE.getKey(type));
            this.selectedData = PARTICLE_TYPES.get(ModParticles.NEW_GLOW_TYPE.get());
        }
        subProperties.getOrCreate((IPropertyType)ParticlePropertyRegistry.COLOR_PROPERTY.get(), () -> new ColorProperty(ParticleColor.defaultParticleColor(), true));
    }

    public ParticleType<? extends PropertyParticleOptions> type() {
        return this.type;
    }

    public ColorProperty getColor() {
        return this.subProperties.getOrDefault((IPropertyType)ParticlePropertyRegistry.COLOR_PROPERTY.get(), new ColorProperty());
    }

    public SoundProperty getSound() {
        return this.subProperties.getOrDefault((IPropertyType)ParticlePropertyRegistry.SOUND_PROPERTY.get(), new SoundProperty(new ConfiguredSpellSound(SoundRegistry.POINTED_DRIPSTONE_WATER)));
    }

    @Override
    public ParticleConfigWidgetProvider buildWidgets(int x, int y, int width, int height) {
        ArrayList<DocEntryButton> buttons = new ArrayList<DocEntryButton>();
        ArrayList<Map.Entry<ParticleType<? extends PropertyParticleOptions>, ParticleData>> particleEntries = new ArrayList<Map.Entry<ParticleType<? extends PropertyParticleOptions>, ParticleData>>(PARTICLE_TYPES.entrySet());
        particleEntries.sort(Comparator.comparingInt(o -> DocPlayerData.favoriteParticles.contains(o.getKey()) ? -1 : 1).thenComparing((o1, o2) -> {
            if (o1.getKey() == ModParticles.NEW_GLOW_TYPE.get()) {
                return -3;
            }
            if (o2.getKey() == ModParticles.NEW_GLOW_TYPE.get()) {
                return 3;
            }
            return this.getTypeName((ParticleType)o1.getKey()).getString().compareTo(this.getTypeName((ParticleType)o2.getKey()).getString());
        }));
        for (Map.Entry<ParticleType<? extends PropertyParticleOptions>, ParticleData> particleType : particleEntries) {
            ParticleType<? extends PropertyParticleOptions> key = particleType.getKey();
            DocEntryButton button = new DocEntryButton(0, 0, ItemStack.EMPTY, this.getTypeName(key), b -> {
                this.selectedData = (ParticleData)particleType.getValue();
                this.type = key;
                this.onDependenciesChanged.run();
            }).setFavoritable(() -> DocPlayerData.favoriteParticles.contains(key), b -> {
                if (DocPlayerData.favoriteParticles.contains(key)) {
                    DocPlayerData.favoriteParticles.remove(key);
                } else {
                    DocPlayerData.favoriteParticles.add(key);
                }
            });
            buttons.add(button);
        }
        return new ListParticleWidgetProvider(x, y, width, height, buttons, 8, () -> this.providerData){

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                DocClientUtils.drawHeader(ParticleTypeProperty.this.getName(), graphics, this.x, this.y, this.width, mouseX, mouseY, partialTicks);
            }

            @Override
            public void renderIcon(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
                DocClientUtils.blit(graphics, DocAssets.PARTICLES_ICON, x, y);
            }

            @Override
            public Component getButtonTitle() {
                return Component.literal((String)(ParticleTypeProperty.this.getName().getString() + ": " + ParticleTypeProperty.this.getTypeName(ParticleTypeProperty.this.selectedData.type()).getString()));
            }

            @Override
            public void getButtonTooltips(List<Component> tooltip) {
                super.getButtonTooltips(tooltip);
                tooltip.add((Component)Component.translatable((String)"ars_nouveau.particle_type_tooltip"));
            }
        };
    }

    private ResourceLocation getKey(ParticleType<?> type) {
        return BuiltInRegistries.PARTICLE_TYPE.getKey(type);
    }

    private Component getTypeName(ParticleType<?> type) {
        ResourceLocation location = this.getKey(type);
        return Component.translatable((String)(location.getNamespace() + ".particle." + location.getPath()));
    }

    @Override
    public IPropertyType getType() {
        return (IPropertyType)ParticlePropertyRegistry.TYPE_PROPERTY.get();
    }

    @Override
    public List<BaseProperty<?>> subProperties() {
        return this.selectedData.getProperties(this);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParticleTypeProperty property = (ParticleTypeProperty)o;
        return Objects.equals(this.type, property.type) && Objects.equals(this.subProperties, property.subProperties) && Objects.equals(this.getType(), property.getType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getType(), this.type, this.subProperties);
    }

    public record ParticleData(ParticleType<? extends PropertyParticleOptions> type, boolean acceptsColor, boolean useLegacyRGB, boolean supportsSound) {
        public ParticleData(ParticleType<? extends PropertyParticleOptions> type, boolean acceptsColor, boolean useLegacyRGB) {
            this(type, acceptsColor, useLegacyRGB, false);
        }

        public ParticleData(ParticleType<? extends PropertyParticleOptions> type, boolean acceptsColor) {
            this(type, acceptsColor, false);
        }

        public ParticleData withSound() {
            return new ParticleData(this.type, this.acceptsColor, this.useLegacyRGB, true);
        }

        public List<BaseProperty<?>> getProperties(ParticleTypeProperty forProp) {
            ArrayList properties = new ArrayList();
            PropMap subPropMap = forProp.subProperties;
            if (this.acceptsColor) {
                ColorProperty colorProperty = subPropMap.createIfMissing(new ColorProperty(ParticleColor.defaultParticleColor(), true));
                colorProperty.isLegacyRGB = this.useLegacyRGB;
                properties.add(colorProperty);
            }
            if (this.supportsSound) {
                properties.add(subPropMap.createIfMissing(new SoundProperty(new ConfiguredSpellSound(SoundRegistry.POINTED_DRIPSTONE_WATER))));
            }
            return properties;
        }
    }
}

