/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.varia;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.ComponentFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class Tools {
    public static void error(Player player, String msg) {
        player.displayClientMessage((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + msg)), false);
    }

    public static void notify(Player player, MutableComponent msg) {
        player.displayClientMessage((Component)msg.withStyle(ChatFormatting.GREEN), false);
    }

    @Nullable
    public static BlockState placeStackAt(Player player, ItemStack blockStack, Level world, BlockPos pos, @Nullable BlockState origState) {
        ItemStack old = player.getItemInHand(InteractionHand.MAIN_HAND);
        player.setItemInHand(InteractionHand.MAIN_HAND, blockStack);
        BlockHitResult trace = new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.UP, pos, false);
        BlockPlaceContext context = new BlockPlaceContext(new UseOnContext(player, InteractionHand.MAIN_HAND, trace));
        Item item = blockStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)item;
            if (origState == null && (origState = itemBlock.getBlock().getStateForPlacement(context)) == null) {
                return null;
            }
            if (itemBlock.place(context).consumesAction()) {
                // empty if block
            }
            player.setItemInHand(InteractionHand.MAIN_HAND, old);
            return origState;
        }
        player.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5);
        blockStack.getItem().useOn((UseOnContext)context);
        player.setItemInHand(InteractionHand.MAIN_HAND, old);
        return world.getBlockState(pos);
    }

    @Nonnull
    public static ItemStack consumeInventoryItem(ItemStack item, Inventory inv, Player player) {
        if (player.isCreative()) {
            return item;
        }
        int i = Tools.finditem(item, inv);
        if (i < 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = inv.getItem(i);
        ItemStack result = stackInSlot.copy();
        result.setCount(1);
        int amount = -1;
        stackInSlot.grow(amount);
        if (stackInSlot.getCount() == 0) {
            inv.setItem(i, ItemStack.EMPTY);
        }
        return result;
    }

    public static void giveItem(Player player, Block block, int cnt) {
        Tools.giveItem(player, new ItemStack((ItemLike)block, cnt));
    }

    public static void giveItem(Player player, ItemStack stack) {
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
    }

    public static int finditem(ItemStack item, Inventory inv) {
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }

    public static Component getBlockName(Block block) {
        ItemStack s = new ItemStack((ItemLike)block, 1);
        if (s.getItem() == null) {
            return ComponentFactory.literal((String)"<null>");
        }
        return s.getHoverName();
    }

    public static int getPlayerXP(Player player) {
        return (int)((float)Tools.getExperienceForLevel(player.experienceLevel) + player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static boolean addPlayerXP(Player player, int amount) {
        int experience = Tools.getPlayerXP(player) + amount;
        if (experience < 0) {
            return false;
        }
        player.totalExperience = experience;
        player.experienceLevel = Tools.getLevelForExperience(experience);
        int expForLevel = Tools.getExperienceForLevel(player.experienceLevel);
        player.experienceProgress = (float)(experience - expForLevel) / (float)player.getXpNeededForNextLevel();
        return true;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return level * 17;
        }
        if (level > 15 && level < 31) {
            return (int)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = Tools.getLevelForExperience(level);
        int nextXP = Tools.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (Tools.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }
}

