/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.wands.Items;

import java.util.List;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.SoundTools;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.modules.wands.WandsConfiguration;
import romelo333.notenoughwands.modules.wands.WandsModule;
import romelo333.notenoughwands.varia.Tools;

public class TeleportationWand
extends GenericWand {
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()});

    public TeleportationWand() {
        this.usageFactor(2.0f);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, list, flagIn);
        this.tooltipBuilder.makeTooltip(mcjty.lib.varia.Tools.getId((Item)this), stack, list, flagIn);
        if (((Boolean)WandsConfiguration.teleportThroughWalls.get()).booleanValue()) {
            list.add((Component)ComponentFactory.translatable((String)"message.notenoughwands.teleportation_wand.sneak1").withStyle(ChatFormatting.GOLD));
        } else {
            list.add((Component)ComponentFactory.translatable((String)"message.notenoughwands.teleportation_wand.sneak2").withStyle(ChatFormatting.GOLD));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            BlockHitResult position;
            if (!this.checkUsage(stack, player, 1.0f)) {
                return InteractionResultHolder.pass((Object)stack);
            }
            Vec3 lookVec = player.getLookAngle();
            Vec3 start = new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
            int distance = (Integer)WandsConfiguration.maxdist.get();
            boolean gothrough = false;
            if (player.isShiftKeyDown()) {
                if (((Boolean)WandsConfiguration.teleportThroughWalls.get()).booleanValue()) {
                    gothrough = true;
                }
                distance /= 2;
            }
            Vec3 end = start.add(lookVec.x * (double)distance, lookVec.y * (double)distance, lookVec.z * (double)distance);
            if (gothrough) {
                position = null;
            } else {
                ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
                position = world.clip(context);
            }
            if (position == null) {
                BlockPos blockPos;
                if (!(!gothrough || world.isEmptyBlock(blockPos = new BlockPos((int)end.x, (int)end.y, (int)end.z)) && world.isEmptyBlock(blockPos.above()))) {
                    Tools.error(player, "You will suffocate if you teleport there!");
                    return InteractionResultHolder.pass((Object)stack);
                }
                player.teleportTo(end.x, end.y, end.z);
            } else {
                BlockHitResult result = position;
                BlockPos blockPos = result.getBlockPos();
                int x = blockPos.getX();
                int y = blockPos.getY();
                int z = blockPos.getZ();
                if (world.isEmptyBlock(blockPos.above()) && world.isEmptyBlock(blockPos.above(2))) {
                    player.teleportTo((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
                } else {
                    switch (result.getDirection()) {
                        case DOWN: {
                            player.teleportTo((double)x + 0.5, (double)(y - 2), (double)z + 0.5);
                            break;
                        }
                        case UP: {
                            Tools.error(player, "You will suffocate if you teleport there!");
                            return InteractionResultHolder.pass((Object)stack);
                        }
                        case NORTH: {
                            player.teleportTo((double)x + 0.5, (double)y, (double)(z - 1) + 0.5);
                            break;
                        }
                        case SOUTH: {
                            player.teleportTo((double)x + 0.5, (double)y, (double)(z + 1) + 0.5);
                            break;
                        }
                        case WEST: {
                            player.teleportTo((double)(x - 1) + 0.5, (double)y, (double)z + 0.5);
                            break;
                        }
                        case EAST: {
                            player.teleportTo((double)(x + 1) + 0.5, (double)y, (double)z + 0.5);
                        }
                    }
                }
            }
            this.registerUsage(stack, player, 1.0f);
            if ((Double)WandsConfiguration.teleportVolume.get() >= 0.01) {
                SoundEvent teleport = WandsModule.TELEPORT_SOUND.get();
                SoundTools.playSound((Level)player.getCommandSenderWorld(), (SoundEvent)teleport, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (double)((Double)WandsConfiguration.teleportVolume.get()), (double)1.0);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

