/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.wands.Items;

import java.util.List;
import mcjty.lib.varia.ComponentFactory;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.modules.wands.WandsConfiguration;
import romelo333.notenoughwands.varia.Tools;

public class PotionWand
extends GenericWand {
    public PotionWand() {
        this.usageFactor(2.0f);
    }

    private String getEffectName(MobEffectInstance potioneffect) {
        Object s1 = I18n.get((String)potioneffect.getDescriptionId(), (Object[])new Object[0]).trim();
        if (potioneffect.getAmplifier() > 0) {
            s1 = (String)s1 + " " + I18n.get((String)("potion.potency." + potioneffect.getAmplifier()), (Object[])new Object[0]).trim();
        }
        if (potioneffect.getDuration() > 20) {
            // empty if block
        }
        return s1;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, list, flagIn);
        list.add((Component)ComponentFactory.literal((String)"Left click on creature to apply effect"));
    }

    @Override
    public void toggleMode(Player player, ItemStack stack) {
        int mode = this.getMode(stack);
        ++mode;
    }

    private int getMode(ItemStack stack) {
        return 0;
    }

    private void addeffect(LivingEntity entity, ItemStack wand, Player player) {
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!player.getCommandSenderWorld().isClientSide) {
            if (entity instanceof LivingEntity) {
                LivingEntity entityLivingBase = (LivingEntity)entity;
                if (!((Boolean)WandsConfiguration.potionAllowHostile.get()).booleanValue() && entityLivingBase instanceof Enemy) {
                    Tools.error(player, "It is not possible to add effects to hostile mobs with this wand!");
                    return true;
                }
                if (!((Boolean)WandsConfiguration.potionAllowPassive.get()).booleanValue() && !(entityLivingBase instanceof Enemy)) {
                    Tools.error(player, "It is not possible to add effects to passive mobs with this wand!");
                    return true;
                }
                float difficultyScale = (float)((double)entityLivingBase.getMaxHealth() * (Double)WandsConfiguration.potionDifficultyMult.get() + (Double)WandsConfiguration.potionDifficultyAdd.get());
                if (!this.checkUsage(stack, player, difficultyScale)) {
                    return true;
                }
                this.addeffect(entityLivingBase, stack, player);
                this.registerUsage(stack, player, difficultyScale);
            } else {
                Tools.error(player, "Please select a living entity!");
            }
        }
        return true;
    }
}

