/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.wands.Items;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Set;
import mcjty.lib.varia.ComponentFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import romelo333.notenoughwands.keys.KeyBindings;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsConfiguration;
import romelo333.notenoughwands.modules.protectionwand.ProtectedBlocks;
import romelo333.notenoughwands.modules.wands.WandUsage;
import romelo333.notenoughwands.modules.wands.WandsConfiguration;
import romelo333.notenoughwands.setup.Registration;
import romelo333.notenoughwands.varia.ClientTools;
import romelo333.notenoughwands.varia.Tools;

public class GenericWand
extends Item {
    protected float usageFactor = 1.0f;

    public GenericWand() {
        super(Registration.createStandardProperties().setNoRepair().stacksTo(1));
    }

    public static double checkPickup(Player player, Level world, BlockPos pos, BlockState state, double maxHardness) {
        float hardness = state.getDestroySpeed((BlockGetter)world, pos);
        if (hardness < 0.0f || (double)hardness > maxHardness) {
            Tools.error(player, "This block is to hard to take!");
            return -1.0;
        }
        if (!state.canEntityDestroy((BlockGetter)world, pos, (Entity)player)) {
            Tools.error(player, "You are not allowed to take this block!");
            return -1.0;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (protectedBlocks.isProtected(world, pos)) {
            Tools.error(player, "This block is protected. You cannot take it!");
            return -1.0;
        }
        double cost = BuildingWandsConfiguration.getBlockCost(state);
        if (cost <= (double)0.001f) {
            Tools.error(player, "It is illegal to take this block");
            return -1.0;
        }
        return cost;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (this.needsPower()) {
            tooltip.add((Component)ComponentFactory.literal((String)("Energy: " + this.getEnergyStored(stack) + " / " + this.getMaxEnergyStored(stack))).withStyle(ChatFormatting.GREEN));
        }
    }

    public boolean isBarVisible(ItemStack pStack) {
        if (this.needsPower() && ((Boolean)WandsConfiguration.showDurabilityBarForRF.get()).booleanValue()) {
            return true;
        }
        return super.isBarVisible(pStack);
    }

    public int getBarWidth(ItemStack stack) {
        if (this.needsPower() && ((Boolean)WandsConfiguration.showDurabilityBarForRF.get()).booleanValue()) {
            int max = this.getMaxEnergyStored(stack);
            return Math.round((float)this.getEnergyStored(stack) * 13.0f / (float)max);
        }
        return super.getBarWidth(stack);
    }

    public GenericWand usageFactor(float usageFactor) {
        this.usageFactor = usageFactor;
        return this;
    }

    protected boolean checkUsage(ItemStack wandStack, Player player, float difficultyScale) {
        if (player.isCreative()) {
            return true;
        }
        if (this.needsXP()) {
            int needsxp = this.calculateXP();
            int experience = Tools.getPlayerXP(player) - (int)((float)needsxp * difficultyScale);
            if (experience <= 0) {
                Tools.error(player, "Not enough experience!");
                return false;
            }
        }
        if (this.needsDamage() && wandStack.getDamageValue() >= wandStack.getMaxDamage()) {
            Tools.error(player, "This wand can no longer be used!");
            return false;
        }
        if (this.needsPower()) {
            int needsrf = this.calculatePower();
            if (this.getEnergyStored(wandStack) < (int)((float)needsrf * difficultyScale)) {
                Tools.error(player, "Not enough energy to use this wand!");
                return false;
            }
        }
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.calculateMaxDamage();
    }

    protected void registerUsage(ItemStack stack, Player player, float difficultyScale) {
        if (player.isCreative()) {
            return;
        }
        if (this.needsXP()) {
            Tools.addPlayerXP(player, -((int)((float)this.calculateXP() * difficultyScale)));
        }
        if (this.needsDamage()) {
            stack.hurtAndBreak(1, (ServerLevel)player.level(), (LivingEntity)player, playerEntity -> {});
        }
        if (this.needsPower()) {
            this.extractEnergy(stack, (int)((float)this.calculatePower() * difficultyScale), false);
        }
    }

    public void toggleMode(Player player, ItemStack stack) {
    }

    public void toggleSubMode(Player player, ItemStack stack) {
    }

    public void renderOverlay(RenderLevelStageEvent evt, Player player, ItemStack wand) {
    }

    protected static void renderOutlines(RenderLevelStageEvent evt, Player p, Set<BlockPos> coordinates, int r, int g, int b) {
        PoseStack matrixStack = evt.getPoseStack();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        ClientTools.renderOutlines(matrixStack, buffer, coordinates, r, g, b);
    }

    protected void showModeKeyDescription(List<Component> list, String suffix) {
        list.add((Component)ComponentFactory.literal((String)"Mode key (").append(KeyBindings.wandModifier.getTranslatedKeyMessage()).append(") to ").append(suffix).withStyle(ChatFormatting.YELLOW));
    }

    protected void showSubModeKeyDescription(List<Component> list, String suffix) {
        list.add((Component)ComponentFactory.literal((String)"Sub-mode key (").append(KeyBindings.wandSubMode.getTranslatedKeyMessage()).append(") to ").append(suffix).withStyle(ChatFormatting.YELLOW));
    }

    public int getEnergyStored(ItemStack container) {
        return (Integer)container.getOrDefault(Registration.ENERGY_COMPONENT, (Object)0);
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.calculateMaxPower();
    }

    private void extractEnergy(ItemStack stack, int amount, boolean simulate) {
        IEnergyStorage capability = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM, null);
        if (capability != null) {
            capability.extractEnergy(amount, simulate);
        }
    }

    private int calculatePower() {
        return (int)(500.0f * this.usageFactor);
    }

    public int calculateMaxPower() {
        return (int)(100000.0f * this.usageFactor);
    }

    private int calculateMaxDamage() {
        return (int)(200.0f / this.usageFactor);
    }

    private int calculateXP() {
        return (int)(10.0f * this.usageFactor);
    }

    private boolean needsPower() {
        return WandsConfiguration.getWandUsage().needsPower();
    }

    private boolean needsDamage() {
        return WandsConfiguration.getWandUsage() == WandUsage.DURABILITY;
    }

    private boolean needsXP() {
        return WandsConfiguration.getWandUsage() == WandUsage.XP;
    }
}

