/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.wands.Items;

import java.util.List;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.ComponentFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.modules.wands.WandsConfiguration;
import romelo333.notenoughwands.modules.wands.WandsModule;
import romelo333.notenoughwands.modules.wands.data.CapturingWandData;
import romelo333.notenoughwands.varia.Tools;

public class CapturingWand
extends GenericWand {
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()});

    public CapturingWand() {
        this.usageFactor(3.0f);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flagIn) {
        EntityType entityType;
        super.appendHoverText(stack, context, list, flagIn);
        this.tooltipBuilder.makeTooltip(mcjty.lib.varia.Tools.getId((Item)this), stack, list, flagIn);
        CapturingWandData data = (CapturingWandData)stack.getOrDefault(WandsModule.CAPTURINGWAND_DATA, (Object)CapturingWandData.DEFAULT);
        if (data.type() != null && (entityType = mcjty.lib.varia.Tools.getEntity((ResourceLocation)data.type())) != null) {
            list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.GREEN) + "Captured mob: ")).append(entityType.getDescription()));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Level world = context.getLevel();
        ItemStack stack = player.getItemInHand(hand);
        BlockPos pos = context.getClickedPos();
        if (!world.isClientSide) {
            CapturingWandData data = (CapturingWandData)stack.getOrDefault(WandsModule.CAPTURINGWAND_DATA, (Object)CapturingWandData.DEFAULT);
            if (data.type() != null) {
                CompoundTag mobCompound = data.tag();
                ResourceLocation type = data.type();
                LivingEntity entityLivingBase = this.createEntity(player, world, type);
                if (entityLivingBase == null) {
                    Tools.error(player, "Something went wrong trying to spawn creature!");
                    return InteractionResult.FAIL;
                }
                entityLivingBase.load(mobCompound);
                entityLivingBase.moveTo((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
                stack.set(WandsModule.CAPTURINGWAND_DATA, (Object)CapturingWandData.DEFAULT);
                world.addFreshEntity((Entity)entityLivingBase);
            } else {
                Tools.error(player, "There is no mob captured in this wand!");
            }
        }
        return InteractionResult.SUCCESS;
    }

    private LivingEntity createEntity(Player player, Level world, ResourceLocation type) {
        EntityType entityType = mcjty.lib.varia.Tools.getEntity((ResourceLocation)type);
        if (entityType != null) {
            return (LivingEntity)entityType.create(world);
        }
        return null;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!player.getCommandSenderWorld().isClientSide) {
            if (entity instanceof LivingEntity) {
                LivingEntity entityLivingBase = (LivingEntity)entity;
                CapturingWandData data = (CapturingWandData)stack.getOrDefault(WandsModule.CAPTURINGWAND_DATA, (Object)CapturingWandData.DEFAULT);
                if (data.type() != null) {
                    Tools.error(player, "There is already a mob in this wand!");
                    return true;
                }
                if (entityLivingBase instanceof Player) {
                    Tools.error(player, "I don't think that player would appreciate being captured!");
                    return true;
                }
                if (!((Boolean)WandsConfiguration.allowHostile.get()).booleanValue() && entityLivingBase instanceof Enemy) {
                    Tools.error(player, "It is not possible to capture hostile mobs with this wand!");
                    return true;
                }
                if (!((Boolean)WandsConfiguration.allowPassive.get()).booleanValue() && !(entityLivingBase instanceof Enemy)) {
                    Tools.error(player, "It is not possible to capture passive mobs with this wand!");
                    return true;
                }
                double cost = WandsConfiguration.getEntityCost(entity);
                if (cost <= (double)0.001f) {
                    Tools.error(player, "It is illegal to take this entity");
                    return true;
                }
                float difficultyScale = (float)((double)entityLivingBase.getMaxHealth() * cost * (Double)WandsConfiguration.difficultyMult.get() + (Double)WandsConfiguration.difficultyAdd.get());
                if (!this.checkUsage(stack, player, difficultyScale)) {
                    return true;
                }
                CompoundTag tagCompound = new CompoundTag();
                entityLivingBase.addAdditionalSaveData(tagCompound);
                stack.set(WandsModule.CAPTURINGWAND_DATA, (Object)new CapturingWandData(mcjty.lib.varia.Tools.getId((EntityType)entity.getType()), tagCompound));
                entity.remove(Entity.RemovalReason.DISCARDED);
                this.registerUsage(stack, player, difficultyScale);
            } else {
                Tools.error(player, "Please select a living entity!");
            }
        }
        return true;
    }
}

