/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.wands.Items;

import java.util.List;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.ComponentFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.FakePlayer;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.modules.wands.WandsConfiguration;
import romelo333.notenoughwands.modules.wands.WandsModule;
import romelo333.notenoughwands.modules.wands.data.AccelerationWandData;
import romelo333.notenoughwands.varia.Tools;

public class AccelerationWand
extends GenericWand {
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"mode", stack -> this.getMode((ItemStack)stack).getDescription())});
    private final RandomSource random = RandomSource.create();

    public AccelerationWand() {
        this.usageFactor(3.0f);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, list, flagIn);
        this.tooltipBuilder.makeTooltip(mcjty.lib.varia.Tools.getId((Item)this), stack, list, flagIn);
        this.showModeKeyDescription(list, "change speed");
        if (Math.abs((Double)WandsConfiguration.fakePlayerFactor.get() - 1.0) >= 0.01) {
            if ((Double)WandsConfiguration.fakePlayerFactor.get() < 0.0) {
                list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.RED) + "Usage in a machine has been disabled in config!")));
            } else if ((Double)WandsConfiguration.fakePlayerFactor.get() > 1.0) {
                list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Usage in a machine will cost more!")));
            }
        }
        if ((Double)WandsConfiguration.fakePlayerFactor.get() >= 0.0 && ((Boolean)WandsConfiguration.lessEffectiveForFakePlayer.get()).booleanValue()) {
            list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Usage in a machine will be less effective!")));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            BlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            AccelerationWandData.Mode mode = this.getMode(stack);
            float cost = mode.getCost();
            int amount = mode.getAmount();
            if (player instanceof FakePlayer) {
                if ((Double)WandsConfiguration.fakePlayerFactor.get() < 0.0) {
                    return InteractionResult.FAIL;
                }
                cost = (float)((double)cost * (Double)WandsConfiguration.fakePlayerFactor.get());
                if (((Boolean)WandsConfiguration.lessEffectiveForFakePlayer.get()).booleanValue()) {
                    amount /= 2;
                }
            }
            if (!this.checkUsage(stack, player, cost)) {
                return InteractionResult.FAIL;
            }
            BlockEntity tileEntity = world.getBlockEntity(pos);
            for (int i = 0; i < amount / (tileEntity == null ? 5 : 1); ++i) {
                EntityBlock entityBlock;
                BlockEntityTicker ticker;
                if (tileEntity == null) {
                    state.tick((ServerLevel)world, pos, this.random);
                    continue;
                }
                Block block2 = state.getBlock();
                if (!(block2 instanceof EntityBlock) || (ticker = (entityBlock = (EntityBlock)block2).getTicker(world, state, tileEntity.getType())) == null) continue;
                ticker.tick(world, pos, state, tileEntity);
            }
            this.registerUsage(stack, player, cost);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void toggleMode(Player player, ItemStack stack) {
        AccelerationWandData.Mode mode = this.getMode(stack).next();
        Tools.notify(player, ComponentFactory.literal((String)("Switched to " + mode.getDescription() + " mode")));
        stack.update(WandsModule.ACCELERATIONWAND_DATA, (Object)AccelerationWandData.DEFAULT, data -> data.withMode(mode));
    }

    private AccelerationWandData.Mode getMode(ItemStack stack) {
        return ((AccelerationWandData)stack.getOrDefault(WandsModule.ACCELERATIONWAND_DATA, (Object)AccelerationWandData.DEFAULT)).mode();
    }
}

