/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.protectionwand.items;

import java.util.List;
import mcjty.lib.varia.ComponentFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import romelo333.notenoughwands.modules.protectionwand.ProtectedBlocks;
import romelo333.notenoughwands.modules.protectionwand.ProtectionWandModule;
import romelo333.notenoughwands.modules.protectionwand.data.ProtectionWandData;
import romelo333.notenoughwands.modules.protectionwand.network.PacketGetProtectedBlockCount;
import romelo333.notenoughwands.modules.protectionwand.network.PacketGetProtectedBlocks;
import romelo333.notenoughwands.modules.protectionwand.network.ReturnProtectedBlockCountHelper;
import romelo333.notenoughwands.modules.protectionwand.network.ReturnProtectedBlocksHelper;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.network.NEWPacketHandler;
import romelo333.notenoughwands.varia.Tools;

public class ProtectionWand
extends GenericWand {
    private final boolean master;
    private static long tooltipLastTime = 0L;
    private static long lastTime = 0L;

    public ProtectionWand(boolean master) {
        if (master) {
            this.usageFactor(3.0f);
        } else {
            this.usageFactor(3.0f);
        }
        this.master = master;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, list, flagIn);
        ProtectionWandData data = (ProtectionWandData)stack.getOrDefault(ProtectionWandModule.PROTECTIONWAND_DATA, (Object)ProtectionWandData.DEFAULT);
        boolean hasid = data.id() != 0;
        ProtectionWandData.Mode mode = data.mode();
        int id = this.getId(stack);
        if (hasid && id != 0 && System.currentTimeMillis() - tooltipLastTime > 250L) {
            tooltipLastTime = System.currentTimeMillis();
            NEWPacketHandler.sendToServer(PacketGetProtectedBlockCount.create(id));
        }
        list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.GREEN) + "Mode: " + mode.getDescription())));
        if (this.master) {
            list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Master wand")));
        } else if (id != 0) {
            list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.GREEN) + "Id: " + id)));
        }
        if (hasid) {
            list.add((Component)ComponentFactory.literal((String)(String.valueOf(ChatFormatting.GREEN) + "Number of protected blocks: " + ReturnProtectedBlockCountHelper.count)));
        }
        list.add((Component)ComponentFactory.literal((String)"Right click to protect or unprotect a block."));
        this.showModeKeyDescription(list, "switch mode");
    }

    @Override
    public void toggleMode(Player player, ItemStack stack) {
        ProtectionWandData.Mode mode = this.getMode(stack).next();
        Tools.notify(player, ComponentFactory.literal((String)("Switched to " + mode.getDescription() + " mode")));
        stack.update(ProtectionWandModule.PROTECTIONWAND_DATA, (Object)ProtectionWandData.DEFAULT, data -> data.withMode(mode));
    }

    private ProtectionWandData.Mode getMode(ItemStack stack) {
        return ((ProtectionWandData)stack.getOrDefault(ProtectionWandModule.PROTECTIONWAND_DATA, (Object)ProtectionWandData.DEFAULT)).mode();
    }

    public int getId(ItemStack stack) {
        if (this.master) {
            return -1;
        }
        return ((ProtectionWandData)stack.getOrDefault(ProtectionWandModule.PROTECTIONWAND_DATA, (Object)ProtectionWandData.DEFAULT)).id();
    }

    @Override
    public void renderOverlay(RenderLevelStageEvent evt, Player player, ItemStack wand) {
        if (System.currentTimeMillis() - lastTime > 250L) {
            lastTime = System.currentTimeMillis();
            NEWPacketHandler.sendToServer(new PacketGetProtectedBlocks());
        }
        if (this.master) {
            ProtectionWand.renderOutlines(evt, player, ReturnProtectedBlocksHelper.childBlocks, 30, 30, 200);
        }
        ProtectionWand.renderOutlines(evt, player, ReturnProtectedBlocksHelper.blocks, 210, 60, 40);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
            int id = this.getOrCreateId(stack, world, protectedBlocks);
            ProtectionWandData.Mode mode = this.getMode(stack);
            if (mode == ProtectionWandData.Mode.MODE_PROTECT) {
                if (!this.checkUsage(stack, player, 1.0f)) {
                    return InteractionResult.FAIL;
                }
                if (!protectedBlocks.protect(player, world, pos, id)) {
                    return InteractionResult.FAIL;
                }
                this.registerUsage(stack, player, 1.0f);
            } else if (mode == ProtectionWandData.Mode.MODE_UNPROTECT) {
                if (!protectedBlocks.unprotect(player, world, pos, id)) {
                    return InteractionResult.FAIL;
                }
            } else {
                int cnt = protectedBlocks.clearProtections(world, id);
                Tools.notify(player, ComponentFactory.literal((String)("Cleared " + cnt + " protected blocks")));
            }
        }
        return InteractionResult.SUCCESS;
    }

    private int getOrCreateId(ItemStack stack, Level world, ProtectedBlocks protectedBlocks) {
        int id = this.getId(stack);
        if (id == 0) {
            int finalId = id = protectedBlocks.getNewId();
            stack.update(ProtectionWandModule.PROTECTIONWAND_DATA, (Object)ProtectionWandData.DEFAULT, data -> data.withId(finalId));
        }
        return id;
    }

    public boolean hasCraftingRemainingItem() {
        return !this.master;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        if (this.hasCraftingRemainingItem(stack)) {
            ItemStack container = new ItemStack((ItemLike)this.getCraftingRemainingItem());
            container.set(ProtectionWandModule.PROTECTIONWAND_DATA, (Object)((ProtectionWandData)stack.get(ProtectionWandModule.PROTECTIONWAND_DATA)));
            return container;
        }
        return ItemStack.EMPTY;
    }
}

