/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.protectionwand;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import romelo333.notenoughwands.modules.protectionwand.ProtectionWandConfiguration;
import romelo333.notenoughwands.varia.Tools;

public class ProtectedBlocks
extends AbstractWorldData<ProtectedBlocks> {
    private static final String NAME = "NEWProtectedBlocks";
    private Map<GlobalPos, Integer> blocks = new HashMap<GlobalPos, Integer>();
    private Map<Pair<ResourceKey<Level>, ChunkPos>, Set<BlockPos>> perDimPerChunkCache = new HashMap<Pair<ResourceKey<Level>, ChunkPos>, Set<BlockPos>>();
    private Map<Integer, Integer> counter = new HashMap<Integer, Integer>();
    private int lastId = 1;
    public static ResourceKey<Level> clientSideWorld = null;
    public static Map<ChunkPos, Set<BlockPos>> clientSideProtectedBlocks = new HashMap<ChunkPos, Set<BlockPos>>();

    public ProtectedBlocks() {
    }

    public ProtectedBlocks(CompoundTag tag) {
        this.lastId = tag.getInt("lastId");
        this.blocks.clear();
        this.perDimPerChunkCache.clear();
        this.counter.clear();
        ListTag list = tag.getList("blocks", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tc = list.getCompound(i);
            String dim = tc.getString("dim");
            GlobalPos block = GlobalPos.of((ResourceKey)LevelTools.getId((ResourceLocation)ResourceLocation.parse((String)dim)), (BlockPos)new BlockPos(tc.getInt("x"), tc.getInt("y"), tc.getInt("z")));
            int id = tc.getInt("id");
            this.blocks.put(block, id);
            this.incrementProtection(id);
        }
    }

    public static ProtectedBlocks getProtectedBlocks(Level world) {
        return (ProtectedBlocks)ProtectedBlocks.getData((Level)world, ProtectedBlocks::new, ProtectedBlocks::new, (String)NAME);
    }

    public static boolean isProtectedClientSide(Level world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        if (!clientSideProtectedBlocks.containsKey(chunkPos)) {
            return false;
        }
        Set<BlockPos> positions = clientSideProtectedBlocks.get(chunkPos);
        return positions.contains(pos);
    }

    public int getNewId() {
        ++this.lastId;
        this.save();
        return this.lastId - 1;
    }

    private void decrementProtection(Integer oldId) {
        int cnt = this.counter.containsKey(oldId) ? this.counter.get(oldId) : 0;
        this.counter.put(oldId, --cnt);
    }

    private void incrementProtection(Integer newId) {
        int cnt = this.counter.containsKey(newId) ? this.counter.get(newId) : 0;
        this.counter.put(newId, ++cnt);
    }

    public int getProtectedBlockCount(int id) {
        return this.counter.containsKey(id) ? this.counter.get(id) : 0;
    }

    private int getMaxProtectedBlocks(int id) {
        if (id == -1) {
            return 0;
        }
        return (Integer)ProtectionWandConfiguration.maximumProtectedBlocks.get();
    }

    public boolean protect(Player player, Level world, BlockPos pos, int id) {
        int max;
        GlobalPos key = GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos);
        if (id != -1 && this.blocks.containsKey(key)) {
            Tools.error(player, "This block is already protected!");
            return false;
        }
        if (this.blocks.containsKey(key)) {
            this.decrementProtection(this.blocks.get(key));
        }
        if ((max = this.getMaxProtectedBlocks(id)) != 0 && this.getProtectedBlockCount(id) >= max) {
            Tools.error(player, "Maximum number of protected blocks reached!");
            return false;
        }
        this.blocks.put(key, id);
        this.clearCache(key);
        this.incrementProtection(id);
        this.save();
        return true;
    }

    public boolean unprotect(Player player, Level world, BlockPos pos, int id) {
        GlobalPos key = GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos);
        if (!this.blocks.containsKey(key)) {
            Tools.error(player, "This block is not protected!");
            return false;
        }
        if (id != -1 && this.blocks.get(key) != id) {
            Tools.error(player, "You have no permission to unprotect this block!");
            return false;
        }
        this.decrementProtection(this.blocks.get(key));
        this.blocks.remove(key);
        this.clearCache(key);
        this.save();
        return true;
    }

    public int clearProtections(Level world, int id) {
        HashSet<GlobalPos> toRemove = new HashSet<GlobalPos>();
        for (Map.Entry<GlobalPos, Integer> entry : this.blocks.entrySet()) {
            if (entry.getValue() != id) continue;
            toRemove.add(entry.getKey());
        }
        int cnt = 0;
        for (GlobalPos coordinate : toRemove) {
            ++cnt;
            this.blocks.remove(coordinate);
            this.clearCache(coordinate);
        }
        this.counter.put(id, 0);
        this.save();
        return cnt;
    }

    public boolean isProtected(Level world, BlockPos pos) {
        return this.blocks.containsKey(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos));
    }

    public boolean hasProtections() {
        return !this.blocks.isEmpty();
    }

    public void fetchProtectedBlocks(Set<BlockPos> coordinates, Level world, int x, int y, int z, float radius, int id) {
        radius *= radius;
        for (Map.Entry<GlobalPos, Integer> entry : this.blocks.entrySet()) {
            BlockPos c;
            float sqdist;
            GlobalPos block;
            if (entry.getValue() != id && (id != -2 || entry.getValue() == -1) || !(block = entry.getKey()).dimension().equals(world.dimension()) || !((sqdist = (float)((x - (c = block.pos()).getX()) * (x - c.getX()) + (y - c.getY()) * (y - c.getY()) + (z - c.getZ()) * (z - c.getZ()))) < radius)) continue;
            coordinates.add(c);
        }
    }

    private void clearCache(GlobalPos pos) {
        ChunkPos chunkpos = new ChunkPos(pos.pos());
        this.perDimPerChunkCache.remove(Pair.of((Object)pos.dimension(), (Object)chunkpos));
    }

    public Map<ChunkPos, Set<BlockPos>> fetchProtectedBlocks(Level world, BlockPos pos) {
        HashMap<ChunkPos, Set<BlockPos>> result = new HashMap<ChunkPos, Set<BlockPos>>();
        ChunkPos chunkpos = new ChunkPos(pos);
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.x - 1, chunkpos.z - 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.x, chunkpos.z - 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.x + 1, chunkpos.z - 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.x - 1, chunkpos.z));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.x, chunkpos.z));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.x + 1, chunkpos.z));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.x - 1, chunkpos.z + 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.x, chunkpos.z + 1));
        this.fetchProtectedBlocks(result, world, new ChunkPos(chunkpos.x + 1, chunkpos.z + 1));
        return result;
    }

    public void fetchProtectedBlocks(Map<ChunkPos, Set<BlockPos>> allresults, Level world, ChunkPos chunkpos) {
        Pair key = Pair.of((Object)world.dimension(), (Object)chunkpos);
        if (this.perDimPerChunkCache.containsKey(key)) {
            allresults.put(chunkpos, this.perDimPerChunkCache.get(key));
            return;
        }
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (Map.Entry<GlobalPos, Integer> entry : this.blocks.entrySet()) {
            ChunkPos bc;
            GlobalPos block = entry.getKey();
            if (!block.dimension().equals(world.dimension()) || !(bc = new ChunkPos(block.pos())).equals((Object)chunkpos)) continue;
            result.add(block.pos());
        }
        allresults.put(chunkpos, result);
        this.perDimPerChunkCache.put((Pair<ResourceKey<Level>, ChunkPos>)key, result);
    }

    public CompoundTag save(CompoundTag tagCompound, HolderLookup.Provider provider) {
        tagCompound.putInt("lastId", this.lastId);
        ListTag list = new ListTag();
        for (Map.Entry<GlobalPos, Integer> entry : this.blocks.entrySet()) {
            GlobalPos block = entry.getKey();
            CompoundTag tc = new CompoundTag();
            tc.putInt("x", block.pos().getX());
            tc.putInt("y", block.pos().getY());
            tc.putInt("z", block.pos().getZ());
            tc.putString("dim", block.dimension().location().toString());
            tc.putInt("id", entry.getValue().intValue());
            list.add((Object)tc);
        }
        tagCompound.put("blocks", (Tag)list);
        return tagCompound;
    }
}

