/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.buildingwands.items;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.SoundTools;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsConfiguration;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsModule;
import romelo333.notenoughwands.modules.buildingwands.data.SwappingWandData;
import romelo333.notenoughwands.modules.protectionwand.ProtectedBlocks;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class SwappingWand
extends GenericWand {
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"mode", stack -> this.getMode((ItemStack)stack).getDescription())});

    public SwappingWand() {
        this.usageFactor(1.0f);
    }

    @Override
    public void toggleMode(Player player, ItemStack stack) {
        SwappingWandData.Mode mode = this.getMode(stack).next();
        Tools.notify(player, ComponentFactory.literal((String)("Switched to " + mode.getDescription() + " mode")));
        stack.update(BuildingWandsModule.SWAPPINGWAND_DATA, (Object)SwappingWandData.DEFAULT, data -> data.withMode(mode));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, list, flagIn);
        this.tooltipBuilder.makeTooltip(mcjty.lib.varia.Tools.getId((Item)this), stack, list, flagIn);
        list.add(this.getBlockDescription(stack));
        this.showModeKeyDescription(list, "switch mode");
    }

    private Component getBlockDescription(ItemStack stack) {
        SwappingWandData data = (SwappingWandData)stack.getOrDefault(BuildingWandsModule.SWAPPINGWAND_DATA, (Object)SwappingWandData.DEFAULT);
        if (data.state().isAir()) {
            return ComponentFactory.literal((String)"No selected block").withStyle(ChatFormatting.RED);
        }
        if (SwappingWand.isSwappingWithOffHand(stack)) {
            return ComponentFactory.literal((String)"Will swap with block in offhand").withStyle(ChatFormatting.GREEN);
        }
        BlockState state = data.state();
        Component name = Tools.getBlockName(state.getBlock());
        return ComponentFactory.literal((String)"Block: ").append(name).withStyle(ChatFormatting.GREEN);
    }

    private static boolean isSwappingWithOffHand(ItemStack stack) {
        return ((SwappingWandData)stack.getOrDefault(BuildingWandsModule.SWAPPINGWAND_DATA, (Object)SwappingWandData.DEFAULT)).offhand();
    }

    private static void enableSwappingWithOffHand(ItemStack stack) {
        stack.update(BuildingWandsModule.SWAPPINGWAND_DATA, (Object)SwappingWandData.DEFAULT, data -> data.withOffhand(true));
    }

    private static void disableSwappingWithOffHand(ItemStack stack) {
        stack.update(BuildingWandsModule.SWAPPINGWAND_DATA, (Object)SwappingWandData.DEFAULT, data -> data.withOffhand(false));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (!heldItem.isEmpty()) {
            if (SwappingWand.isSwappingWithOffHand(heldItem)) {
                SwappingWand.disableSwappingWithOffHand(heldItem);
                if (world.isClientSide) {
                    Tools.notify(player, ComponentFactory.literal((String)"Switched to swapping with selected block"));
                }
            } else {
                SwappingWand.enableSwappingWithOffHand(heldItem);
                if (world.isClientSide) {
                    Tools.notify(player, ComponentFactory.literal((String)"Switched to swapping with block in offhand"));
                }
            }
        }
        return super.use(world, player, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            if (player.isShiftKeyDown()) {
                this.selectBlock(stack, player, world, pos);
            } else {
                this.placeBlock(stack, player, world, pos, side);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void placeBlock(ItemStack stack, Player player, Level world, BlockPos pos, Direction side) {
        float hardness;
        BlockState blockState;
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        SwappingWandData data = (SwappingWandData)stack.getOrDefault(BuildingWandsModule.SWAPPINGWAND_DATA, (Object)SwappingWandData.DEFAULT);
        if (data.state().isAir()) {
            Tools.error(player, "First select a block by sneaking");
            return;
        }
        if (SwappingWand.isSwappingWithOffHand(stack)) {
            ItemStack off = player.getOffhandItem();
            if (off.isEmpty()) {
                Tools.error(player, "You need to hold a block in your offhand!");
                return;
            }
            Item item = off.getItem();
            if (!(item instanceof BlockItem)) {
                Tools.error(player, "The item in your offhand cannot be placed!");
                return;
            }
            BlockItem itemBlock = (BlockItem)item;
            blockState = itemBlock.getBlock().defaultBlockState();
            hardness = blockState.getDestroySpeed((BlockGetter)world, pos);
        } else {
            blockState = data.state();
            hardness = data.hardness().floatValue();
        }
        BlockState oldState = world.getBlockState(pos);
        Block oldblock = oldState.getBlock();
        double cost = BuildingWandsConfiguration.getBlockCost(oldState);
        if (cost <= (double)0.001f) {
            Tools.error(player, "It is illegal to swap this block");
            return;
        }
        float blockHardness = oldState.getDestroySpeed((BlockGetter)world, pos);
        if (blockState == oldState) {
            return;
        }
        if (blockHardness < -0.1f) {
            Tools.error(player, "This block cannot be swapped!");
            return;
        }
        if (!player.isCreative() && (double)Math.abs(hardness - blockHardness) >= (Double)BuildingWandsConfiguration.hardnessDistance.get()) {
            Tools.error(player, "The hardness of this blocks differs too much to swap!");
            return;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (protectedBlocks.isProtected(world, pos)) {
            Tools.error(player, "This block is protected. You cannot replace it!");
            return;
        }
        Set<BlockPos> coordinates = this.findSuitableBlocks(stack, world, side, pos, oldState);
        boolean notenough = false;
        for (BlockPos coordinate : coordinates) {
            if (!this.checkUsage(stack, player, 1.0f)) {
                return;
            }
            BlockHitResult result = new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.UP, coordinate, false);
            ItemStack pickBlock = blockState.getCloneItemStack((HitResult)result, (LevelReader)world, coordinate, player);
            ItemStack consumed = Tools.consumeInventoryItem(pickBlock, player.getInventory(), player);
            if (!consumed.isEmpty()) {
                if (!player.isCreative()) {
                    ItemStack oldblockItem = oldblock.getCloneItemStack(oldState, null, (LevelReader)world, pos, player);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)oldblockItem);
                }
                SoundTools.playSound((Level)world, (SoundEvent)blockState.getSoundType().getStepSound(), (double)coordinate.getX(), (double)coordinate.getY(), (double)coordinate.getZ(), (double)1.0, (double)1.0);
                BlockSnapshot blocksnapshot = BlockSnapshot.create((ResourceKey)world.dimension(), (LevelAccessor)world, (BlockPos)coordinate);
                world.setBlockAndUpdate(coordinate, Blocks.AIR.defaultBlockState());
                Tools.placeStackAt(player, consumed, world, coordinate, null);
                if (EventHooks.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
                    blocksnapshot.restore(0);
                    if (!player.isCreative()) {
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)consumed);
                    }
                }
                player.containerMenu.broadcastChanges();
                this.registerUsage(stack, player, 1.0f);
                continue;
            }
            notenough = true;
        }
        if (notenough) {
            Tools.error(player, "You don't have the right block");
        }
    }

    private void selectBlock(ItemStack stack, Player player, Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        Component name = Tools.getBlockName(block);
        if (name == null) {
            Tools.error(player, "You cannot select this block!");
        } else {
            double cost = BuildingWandsConfiguration.getBlockCost(state);
            if (cost <= (double)0.001f) {
                Tools.error(player, "It is illegal to swap this block");
                return;
            }
            float hardness = state.getDestroySpeed((BlockGetter)world, pos);
            stack.set(BuildingWandsModule.SWAPPINGWAND_DATA, (Object)new SwappingWandData(this.getMode(stack), state, false, Float.valueOf(hardness)));
            Tools.notify(player, ComponentFactory.literal((String)"Selected block: ").append(name));
        }
    }

    @Override
    public void renderOverlay(RenderLevelStageEvent evt, Player player, ItemStack wand) {
        HitResult mouseOver = Minecraft.getInstance().hitResult;
        if (mouseOver instanceof BlockHitResult) {
            BlockPos blockPos;
            BlockHitResult br = (BlockHitResult)mouseOver;
            Level world = player.getCommandSenderWorld();
            BlockState state = world.getBlockState(blockPos = br.getBlockPos());
            if (!state.isAir() && ((SwappingWandData)wand.getOrDefault(BuildingWandsModule.SWAPPINGWAND_DATA, (Object)SwappingWandData.DEFAULT)).state() == state) {
                Set<BlockPos> coordinates = this.findSuitableBlocks(wand, world, br.getDirection(), blockPos, state);
                SwappingWand.renderOutlines(evt, player, coordinates, 200, 230, 180);
            }
        }
    }

    private Set<BlockPos> findSuitableBlocks(ItemStack stack, Level world, Direction sideHit, BlockPos pos, BlockState centerState) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        SwappingWandData.Mode mode = this.getMode(stack);
        int dim = 0;
        switch (mode) {
            case MODE_SINGLE: {
                coordinates.add(pos);
                return coordinates;
            }
            case MODE_3X3: {
                dim = 1;
                break;
            }
            case MODE_5X5: {
                dim = 2;
                break;
            }
            case MODE_7X7: {
                dim = 3;
            }
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        switch (sideHit) {
            case UP: 
            case DOWN: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, dx, y, dz, centerState, coordinates);
                    }
                }
                break;
            }
            case SOUTH: 
            case NORTH: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dy = y - dim; dy <= y + dim; ++dy) {
                        this.checkAndAddBlock(world, dx, dy, z, centerState, coordinates);
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int dy = y - dim; dy <= y + dim; ++dy) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, x, dy, dz, centerState, coordinates);
                    }
                }
                break;
            }
        }
        return coordinates;
    }

    private void checkAndAddBlock(Level world, int x, int y, int z, BlockState centerBlock, Set<BlockPos> coordinates) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockState state = world.getBlockState(pos);
        if (state == centerBlock) {
            coordinates.add(pos);
        }
    }

    private SwappingWandData.Mode getMode(ItemStack stack) {
        return ((SwappingWandData)stack.getOrDefault(BuildingWandsModule.SWAPPINGWAND_DATA, (Object)SwappingWandData.DEFAULT)).mode();
    }
}

