/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.buildingwands.items;

import java.util.List;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.ComponentFactory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsConfiguration;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsModule;
import romelo333.notenoughwands.modules.buildingwands.data.MovingWandData;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class MovingWand
extends GenericWand {
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()});

    public MovingWand() {
        this.usageFactor(1.5f);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, list, flagIn);
        this.tooltipBuilder.makeTooltip(mcjty.lib.varia.Tools.getId((Item)this), stack, list, flagIn);
        list.add(this.getBlockDescription(stack));
    }

    private Component getBlockDescription(ItemStack stack) {
        if (!this.hasBlock(stack)) {
            return ComponentFactory.literal((String)"Wand is empty").withStyle(ChatFormatting.RED);
        }
        BlockState state = ((MovingWandData)stack.getOrDefault(BuildingWandsModule.MOVINGWAND_DATA, (Object)MovingWandData.DEFAULT)).state();
        Component name = Tools.getBlockName(state.getBlock());
        return ComponentFactory.literal((String)"Block: ").append(name).withStyle(ChatFormatting.GREEN);
    }

    private boolean hasBlock(ItemStack stack) {
        return !((MovingWandData)stack.getOrDefault(BuildingWandsModule.MOVINGWAND_DATA, (Object)MovingWandData.DEFAULT)).state().isAir();
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide && this.hasBlock(stack)) {
            int distance;
            Vec3 end;
            Vec3 lookVec = player.getLookAngle();
            Vec3 start = new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
            ClipContext context = new ClipContext(start, end = start.add(lookVec.x * (double)(distance = ((Integer)BuildingWandsConfiguration.placeDistance.get()).intValue()), lookVec.y * (double)distance, lookVec.z * (double)distance), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
            BlockHitResult position = world.clip(context);
            if (position == null) {
                this.place(stack, world, new BlockPos((int)end.x, (int)end.y, (int)end.z), null, player);
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        if (!world.isClientSide) {
            if (this.hasBlock(stack)) {
                this.place(stack, world, pos, side, player);
            } else {
                this.pickup(stack, player, world, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useOn(UseOnContext context) {
        return InteractionResult.SUCCESS;
    }

    private void place(ItemStack stack, Level world, BlockPos pos, Direction side, Player player) {
        BlockPos pp = side == null ? pos : pos.relative(side);
        BlockState old = world.getBlockState(pp);
        if (!world.isEmptyBlock(pp) && !old.canBeReplaced()) {
            Tools.error(player, "Something is in the way!");
            return;
        }
        MovingWandData data = (MovingWandData)stack.getOrDefault(BuildingWandsModule.MOVINGWAND_DATA, (Object)MovingWandData.DEFAULT);
        BlockState blockState = data.state();
        BlockSnapshot blocksnapshot = BlockSnapshot.create((ResourceKey)world.dimension(), (LevelAccessor)world, (BlockPos)pp);
        world.setBlock(pp, blockState, 0);
        if (EventHooks.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
            blocksnapshot.restore(0);
            return;
        }
        if (!data.tag().isEmpty()) {
            CompoundTag tc = data.tag();
            BlockEntity tileEntity = world.getBlockEntity(pp);
            if (tileEntity != null) {
                tileEntity.loadWithComponents(tc, (HolderLookup.Provider)world.registryAccess());
                tileEntity.setChanged();
                world.sendBlockUpdated(pp, blockState, blockState, 3);
            }
        }
        stack.set(BuildingWandsModule.MOVINGWAND_DATA, (Object)MovingWandData.DEFAULT);
    }

    private void pickup(ItemStack stack, Player player, Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        double cost = MovingWand.checkPickup(player, world, pos, state, (Double)BuildingWandsConfiguration.maxHardness.get());
        if (cost < 0.0) {
            return;
        }
        if (!this.checkUsage(stack, player, (float)cost)) {
            return;
        }
        ItemStack s = state.getBlock().getCloneItemStack((LevelReader)world, pos, state);
        Component name = s.isEmpty() ? Tools.getBlockName(state.getBlock()) : s.getHoverName();
        if (name == null) {
            Tools.error(player, "You cannot select this block!");
        } else {
            BlockEntity tileEntity = world.getBlockEntity(pos);
            if (tileEntity != null) {
                CompoundTag tc = tileEntity.saveWithoutMetadata((HolderLookup.Provider)world.registryAccess());
                world.removeBlockEntity(pos);
                stack.set(BuildingWandsModule.MOVINGWAND_DATA, (Object)new MovingWandData(state, tc));
            } else {
                stack.set(BuildingWandsModule.MOVINGWAND_DATA, (Object)new MovingWandData(state, new CompoundTag()));
            }
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            Tools.notify(player, ComponentFactory.literal((String)"You took: ").append(name));
            this.registerUsage(stack, player, (float)cost);
        }
    }
}

