/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.buildingwands.items;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.SoundTools;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsConfiguration;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsModule;
import romelo333.notenoughwands.modules.buildingwands.data.DisplacementWandData;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class DisplacementWand
extends GenericWand {
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"mode", stack -> this.getMode((ItemStack)stack).getDescription())});

    public DisplacementWand() {
        this.usageFactor(1.0f);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, list, flagIn);
        this.tooltipBuilder.makeTooltip(mcjty.lib.varia.Tools.getId((Item)this), stack, list, flagIn);
        this.showModeKeyDescription(list, "switch mode");
    }

    @Override
    public void toggleMode(Player player, ItemStack stack) {
        DisplacementWandData.Mode mode = ((DisplacementWandData)stack.getOrDefault(BuildingWandsModule.DISPLACEMENTWAND_DATA, (Object)DisplacementWandData.DEFAULT)).mode().next();
        Tools.notify(player, ComponentFactory.literal((String)("Switched to " + mode.getDescription() + " mode")));
        stack.update(BuildingWandsModule.DISPLACEMENTWAND_DATA, (Object)DisplacementWandData.DEFAULT, data -> data.withMode(mode));
    }

    private DisplacementWandData.Mode getMode(ItemStack stack) {
        return ((DisplacementWandData)stack.getOrDefault(BuildingWandsModule.DISPLACEMENTWAND_DATA, (Object)DisplacementWandData.DEFAULT)).mode();
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level world = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        if (!world.isClientSide) {
            if (player.isShiftKeyDown()) {
                this.pullBlocks(stack, player, world, pos, side);
            } else {
                this.pushBlocks(stack, player, world, pos, side);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void pullBlocks(ItemStack stack, Player player, Level world, BlockPos pos, Direction side) {
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        Set<BlockPos> coordinates = this.findSuitableBlocks(stack, world, side, pos);
        int cnt = this.moveBlocks(player, world, coordinates, side);
        if (cnt > 0) {
            this.registerUsage(stack, player, 1.0f);
        }
    }

    private void pushBlocks(ItemStack stack, Player player, Level world, BlockPos pos, Direction side) {
        if (!this.checkUsage(stack, player, 1.0f)) {
            return;
        }
        Set<BlockPos> coordinates = this.findSuitableBlocks(stack, world, side, pos);
        int cnt = this.moveBlocks(player, world, coordinates, side.getOpposite());
        if (cnt > 0) {
            this.registerUsage(stack, player, 1.0f);
        }
    }

    private int moveBlocks(Player player, Level world, Set<BlockPos> coordinates, Direction direction) {
        int cnt = 0;
        for (BlockPos coordinate : coordinates) {
            double cost;
            BlockState state = world.getBlockState(coordinate);
            Block block = state.getBlock();
            BlockPos otherC = coordinate.relative(direction);
            BlockState otherState = world.getBlockState(otherC);
            if (!otherState.canBeReplaced() || !((cost = GenericWand.checkPickup(player, world, otherC, state, (Double)BuildingWandsConfiguration.maxHardness.get())) >= 0.0)) continue;
            ++cnt;
            SoundTools.playSound((Level)world, (SoundEvent)block.getSoundType(state, (LevelReader)world, coordinate, (Entity)player).getStepSound(), (double)coordinate.getX(), (double)coordinate.getY(), (double)coordinate.getZ(), (double)1.0, (double)1.0);
            BlockEntity tileEntity = world.getBlockEntity(coordinate);
            CompoundTag tc = null;
            if (tileEntity != null) {
                tc = tileEntity.saveWithoutMetadata((HolderLookup.Provider)world.registryAccess());
                world.removeBlockEntity(coordinate);
            }
            world.setBlock(coordinate, Blocks.AIR.defaultBlockState(), 0);
            BlockSnapshot blocksnapshot = BlockSnapshot.create((ResourceKey)world.dimension(), (LevelAccessor)world, (BlockPos)otherC);
            BlockState blockState = block.defaultBlockState();
            world.setBlock(otherC, blockState, 3);
            if (EventHooks.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
                blocksnapshot.restore(0);
                world.setBlock(coordinate, blockState, 3);
                otherC = coordinate;
            }
            if (tc == null || (tileEntity = world.getBlockEntity(otherC)) == null) continue;
            tileEntity.loadWithComponents(tc, (HolderLookup.Provider)world.registryAccess());
            tileEntity.setChanged();
            world.sendBlockUpdated(otherC, blockState, blockState, 3);
        }
        return cnt;
    }

    @Override
    public void renderOverlay(RenderLevelStageEvent evt, Player player, ItemStack wand) {
        HitResult mouseOver = Minecraft.getInstance().hitResult;
        if (mouseOver instanceof BlockHitResult) {
            BlockPos blockPos;
            BlockHitResult br = (BlockHitResult)mouseOver;
            Level world = player.getCommandSenderWorld();
            BlockState state = world.getBlockState(blockPos = br.getBlockPos());
            if (!state.isAir()) {
                Set<BlockPos> coordinates = this.findSuitableBlocks(wand, world, br.getDirection(), blockPos);
                DisplacementWand.renderOutlines(evt, player, coordinates, 200, 230, 180);
            }
        }
    }

    private Set<BlockPos> findSuitableBlocks(ItemStack stack, Level world, Direction sideHit, BlockPos pos) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        DisplacementWandData.Mode mode = this.getMode(stack);
        int dim = 0;
        switch (mode) {
            case MODE_SINGLE: {
                coordinates.add(pos);
                return coordinates;
            }
            case MODE_3X3: {
                dim = 1;
                break;
            }
            case MODE_5X5: {
                dim = 2;
                break;
            }
            case MODE_7X7: {
                dim = 3;
            }
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        switch (sideHit) {
            case UP: 
            case DOWN: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, dx, y, dz, coordinates);
                    }
                }
                break;
            }
            case SOUTH: 
            case NORTH: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dy = y - dim; dy <= y + dim; ++dy) {
                        this.checkAndAddBlock(world, dx, dy, z, coordinates);
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int dy = y - dim; dy <= y + dim; ++dy) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        this.checkAndAddBlock(world, x, dy, dz, coordinates);
                    }
                }
                break;
            }
        }
        return coordinates;
    }

    private void checkAndAddBlock(Level world, int x, int y, int z, Set<BlockPos> coordinates) {
        BlockPos pos = new BlockPos(x, y, z);
        if (!world.isEmptyBlock(pos)) {
            coordinates.add(pos);
        }
    }
}

