/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.buildingwands.items;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.SoundTools;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import romelo333.notenoughwands.modules.buildingwands.BuildingWandsModule;
import romelo333.notenoughwands.modules.buildingwands.data.BuildingWandData;
import romelo333.notenoughwands.modules.wands.Items.GenericWand;
import romelo333.notenoughwands.varia.Tools;

public class BuildingWand
extends GenericWand {
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.notenoughwands.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"undo", stack -> this.countUndoStates((ItemStack)stack) > 0, stack -> Integer.toString(this.countUndoStates((ItemStack)stack))), TooltipBuilder.parameter((String)"mode", stack -> this.getMode((ItemStack)stack).getDescription()), TooltipBuilder.parameter((String)"submode", stack -> this.getSubMode((ItemStack)stack) == BuildingWandData.OrientationMode.ROTATED, stack -> this.getSubMode((ItemStack)stack).getDescription())});

    public BuildingWand() {
        this.usageFactor(1.0f);
    }

    private int countUndoStates(ItemStack stack) {
        return ((BuildingWandData)stack.getOrDefault(BuildingWandsModule.BUILDINGWAND_DATA, (Object)BuildingWandData.DEFAULT)).undoStates().size();
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flags) {
        super.appendHoverText(itemStack, context, list, flags);
        this.tooltipBuilder.makeTooltip(mcjty.lib.varia.Tools.getId((Item)this), itemStack, list, flags);
        this.showModeKeyDescription(list, "switch mode");
        this.showSubModeKeyDescription(list, "change orientation");
    }

    @Override
    public void toggleMode(Player player, ItemStack stack) {
        BuildingWandData.Mode mode = this.getMode(stack).next();
        Tools.notify(player, ComponentFactory.literal((String)("Switched to " + mode.getDescription() + " mode")));
        stack.update(BuildingWandsModule.BUILDINGWAND_DATA, (Object)BuildingWandData.DEFAULT, data -> data.withMode(mode));
    }

    @Override
    public void toggleSubMode(Player player, ItemStack stack) {
        BuildingWandData.OrientationMode subMode = this.getSubMode(stack).next();
        stack.update(BuildingWandsModule.BUILDINGWAND_DATA, (Object)BuildingWandData.DEFAULT, data -> data.withOrientationMode(subMode));
    }

    private BuildingWandData.Mode getMode(ItemStack stack) {
        return ((BuildingWandData)stack.getOrDefault(BuildingWandsModule.BUILDINGWAND_DATA, (Object)BuildingWandData.DEFAULT)).mode();
    }

    private BuildingWandData.OrientationMode getSubMode(ItemStack stack) {
        return ((BuildingWandData)stack.getOrDefault(BuildingWandsModule.BUILDINGWAND_DATA, (Object)BuildingWandData.DEFAULT)).orientationMode();
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        ItemStack wandStack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            if (player.isShiftKeyDown()) {
                this.undoPlaceBlock(wandStack, player, world, pos);
            } else {
                this.placeBlock(wandStack, player, world, pos, side);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void placeBlock(ItemStack wandStack, Player player, Level world, BlockPos pos, Direction side) {
        if (!this.checkUsage(wandStack, player, 1.0f)) {
            return;
        }
        boolean notenough = false;
        BlockState blockState = world.getBlockState(pos);
        Set<BlockPos> coordinates = this.findSuitableBlocks(wandStack, world, side, pos, blockState);
        HashSet<BlockPos> undo = new HashSet<BlockPos>();
        for (BlockPos coordinate : coordinates) {
            if (!this.checkUsage(wandStack, player, 1.0f)) break;
            BlockHitResult result = new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.UP, coordinate, false);
            ItemStack pickBlock = blockState.getCloneItemStack((HitResult)result, (LevelReader)world, coordinate, player);
            ItemStack consumed = Tools.consumeInventoryItem(pickBlock, player.getInventory(), player);
            if (!consumed.isEmpty()) {
                SoundTools.playSound((Level)world, (SoundEvent)blockState.getSoundType().getStepSound(), (double)coordinate.getX(), (double)coordinate.getY(), (double)coordinate.getZ(), (double)1.0, (double)1.0);
                BlockSnapshot blocksnapshot = BlockSnapshot.create((ResourceKey)world.dimension(), (LevelAccessor)world, (BlockPos)coordinate);
                Tools.placeStackAt(player, consumed, world, coordinate, null);
                if (EventHooks.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
                    blocksnapshot.restore(0);
                    if (!player.isCreative()) {
                        Tools.giveItem(player, consumed);
                    }
                }
                player.containerMenu.broadcastChanges();
                this.registerUsage(wandStack, player, 1.0f);
                undo.add(coordinate);
                continue;
            }
            notenough = true;
        }
        if (notenough) {
            Tools.error(player, "You don't have the right block");
        }
        this.registerUndo(wandStack, blockState, world, undo);
    }

    private void registerUndo(ItemStack stack, BlockState state, Level world, Set<BlockPos> undo) {
        BuildingWandData.UndoState undoState = new BuildingWandData.UndoState((ResourceKey<Level>)world.dimension(), state, undo);
        stack.update(BuildingWandsModule.BUILDINGWAND_DATA, (Object)BuildingWandData.DEFAULT, d -> d.pushUndoState(undoState));
    }

    private void undoPlaceBlock(ItemStack stack, Player player, Level world, BlockPos pos) {
        BuildingWandData data = (BuildingWandData)stack.getOrDefault(BuildingWandsModule.BUILDINGWAND_DATA, (Object)BuildingWandData.DEFAULT);
        if (data.undoStates().isEmpty()) {
            Tools.error(player, "Nothing to undo!");
            return;
        }
        int index = data.findUndoStateIndex((ResourceKey<Level>)world.dimension(), pos);
        if (index == -1) {
            Tools.error(player, "Select at least one block of the area you want to undo!");
            return;
        }
        BuildingWandData.UndoState undoState = data.undoStates().get(index);
        ArrayList<BuildingWandData.UndoState> newUndoStates = new ArrayList<BuildingWandData.UndoState>(data.undoStates());
        newUndoStates.remove(index);
        stack.update(BuildingWandsModule.BUILDINGWAND_DATA, (Object)BuildingWandData.DEFAULT, d -> new BuildingWandData(d.mode(), d.orientationMode(), newUndoStates));
        this.performUndo(player, world, pos, undoState);
    }

    private void performUndo(Player player, Level world, BlockPos pos, BuildingWandData.UndoState undoState) {
        BlockState state = undoState.state();
        int cnt = 0;
        for (BlockPos coordinate : undoState.positions()) {
            BlockState testState = world.getBlockState(coordinate);
            if (testState != state) continue;
            SoundTools.playSound((Level)world, (SoundEvent)state.getSoundType().getStepSound(), (double)coordinate.getX(), (double)coordinate.getY(), (double)coordinate.getZ(), (double)1.0, (double)1.0);
            BlockSnapshot blocksnapshot = BlockSnapshot.create((ResourceKey)world.dimension(), (LevelAccessor)world, (BlockPos)coordinate);
            world.setBlockAndUpdate(coordinate, Blocks.AIR.defaultBlockState());
            if (EventHooks.onBlockPlace((Entity)player, (BlockSnapshot)blocksnapshot, (Direction)Direction.UP)) {
                blocksnapshot.restore(0);
                continue;
            }
            ++cnt;
        }
        if (cnt > 0 && !player.isCreative()) {
            BlockHitResult result = new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.UP, pos, false);
            ItemStack itemStack = state.getCloneItemStack((HitResult)result, (LevelReader)world, pos, player);
            itemStack.setCount(cnt);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)itemStack);
            player.containerMenu.broadcastChanges();
        }
    }

    @Override
    public void renderOverlay(RenderLevelStageEvent evt, Player player, ItemStack wand) {
        HitResult mouseOver = Minecraft.getInstance().hitResult;
        if (!(mouseOver instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult btrace = (BlockHitResult)mouseOver;
        if (btrace.getDirection() != null && btrace.getBlockPos() != null) {
            Level world = player.getCommandSenderWorld();
            BlockPos blockPos = btrace.getBlockPos();
            if (blockPos == null) {
                return;
            }
            BlockState blockState = world.getBlockState(blockPos);
            Block block = blockState.getBlock();
            if (block != null && !blockState.isAir()) {
                if (player.isShiftKeyDown()) {
                    BuildingWandData data = (BuildingWandData)wand.getOrDefault(BuildingWandsModule.BUILDINGWAND_DATA, (Object)BuildingWandData.DEFAULT);
                    if (data == null) {
                        return;
                    }
                    int index = data.findUndoStateIndex((ResourceKey<Level>)world.dimension(), blockPos);
                    if (index == -1) {
                        return;
                    }
                    BuildingWand.renderOutlines(evt, player, data.undoStates().get(index).positions(), 240, 30, 0);
                } else {
                    Set<BlockPos> coordinates = this.findSuitableBlocks(wand, world, btrace.getDirection(), blockPos, blockState);
                    BuildingWand.renderOutlines(evt, player, coordinates, 50, 250, 180);
                }
            }
        }
    }

    private Set<BlockPos> findSuitableBlocks(ItemStack stack, Level world, Direction sideHit, BlockPos pos, BlockState state) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        HashSet<BlockPos> done = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
        todo.addLast(pos);
        this.findSuitableBlocks(world, coordinates, done, todo, sideHit, state, this.getMode(stack).getAmount(), this.getMode(stack) == BuildingWandData.Mode.MODE_9ROW || this.getMode(stack) == BuildingWandData.Mode.MODE_25ROW, this.getSubMode(stack));
        return coordinates;
    }

    private void findSuitableBlocks(Level world, Set<BlockPos> coordinates, Set<BlockPos> done, Deque<BlockPos> todo, Direction direction, BlockState state, int maxAmount, boolean rowMode, BuildingWandData.OrientationMode rotated) {
        BlockPos offset;
        BlockPos base;
        Direction dirA = null;
        Direction dirB = null;
        if (rowMode) {
            base = todo.getFirst();
            offset = base.relative(direction);
            dirA = rotated == BuildingWandData.OrientationMode.ROTATED ? this.dir2(direction) : this.dir1(direction);
            dirB = dirA.getOpposite();
            if (!this.isSuitable(world, state, base.relative(dirA), offset.relative(dirA)) || !this.isSuitable(world, state, base.relative(dirB), offset.relative(dirB))) {
                dirA = rotated == BuildingWandData.OrientationMode.ROTATED ? this.dir3(direction) : this.dir2(direction);
                dirB = dirA.getOpposite();
                if (!this.isSuitable(world, state, base.relative(dirA), offset.relative(dirA)) || !this.isSuitable(world, state, base.relative(dirB), offset.relative(dirB))) {
                    dirA = rotated == BuildingWandData.OrientationMode.ROTATED ? this.dir1(direction) : this.dir3(direction);
                    dirB = dirA.getOpposite();
                }
            }
        }
        while (!todo.isEmpty() && coordinates.size() < maxAmount) {
            base = todo.pollFirst();
            if (done.contains(base)) continue;
            done.add(base);
            offset = base.relative(direction);
            if (!this.isSuitable(world, state, base, offset)) continue;
            coordinates.add(offset);
            if (rowMode) {
                todo.addLast(base.relative(dirA));
                todo.addLast(base.relative(dirB));
                continue;
            }
            todo.addLast(base.relative(this.dir1(direction)));
            todo.addLast(base.relative(this.dir1(direction).getOpposite()));
            todo.addLast(base.relative(this.dir2(direction)));
            todo.addLast(base.relative(this.dir2(direction).getOpposite()));
            todo.addLast(base.relative(this.dir1(direction)).relative(this.dir2(direction)));
            todo.addLast(base.relative(this.dir1(direction)).relative(this.dir2(direction).getOpposite()));
            todo.addLast(base.relative(this.dir1(direction).getOpposite()).relative(this.dir2(direction)));
            todo.addLast(base.relative(this.dir1(direction).getOpposite()).relative(this.dir2(direction).getOpposite()));
        }
    }

    private boolean isSuitable(Level world, BlockState state, BlockPos base, BlockPos offset) {
        BlockState destState = world.getBlockState(offset);
        BlockState baseState = world.getBlockState(base);
        return baseState == state && destState.canBeReplaced();
    }

    private Direction dir1(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.UP -> Direction.EAST;
            case Direction.NORTH, Direction.SOUTH -> Direction.EAST;
            case Direction.WEST, Direction.EAST -> Direction.DOWN;
        };
    }

    private Direction dir2(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.UP -> Direction.SOUTH;
            case Direction.NORTH, Direction.SOUTH -> Direction.DOWN;
            case Direction.WEST, Direction.EAST -> Direction.SOUTH;
        };
    }

    private Direction dir3(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.UP -> Direction.SOUTH;
            case Direction.NORTH, Direction.SOUTH -> Direction.WEST;
            case Direction.WEST, Direction.EAST -> Direction.SOUTH;
        };
    }
}

