/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.buildingwands.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public record SwappingWandData(Mode mode, BlockState state, Boolean offhand, Float hardness) {
    public static final SwappingWandData DEFAULT = new SwappingWandData(Mode.MODE_3X3, Blocks.AIR.defaultBlockState(), false, Float.valueOf(0.0f));
    public static final Codec<SwappingWandData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(Mode::valueOf, Enum::name).fieldOf("mode").forGetter(SwappingWandData::mode), (App)BlockState.CODEC.fieldOf("state").forGetter(SwappingWandData::state), (App)Codec.BOOL.fieldOf("offhand").forGetter(SwappingWandData::offhand), (App)Codec.FLOAT.optionalFieldOf("hardness", (Object)Float.valueOf(0.0f)).forGetter(SwappingWandData::hardness)).apply((Applicative)instance, SwappingWandData::new));
    public static final StreamCodec<FriendlyByteBuf, SwappingWandData> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(Mode.class), SwappingWandData::mode, (StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY), SwappingWandData::state, (StreamCodec)ByteBufCodecs.BOOL, SwappingWandData::offhand, (StreamCodec)ByteBufCodecs.FLOAT, SwappingWandData::hardness, SwappingWandData::new);

    public SwappingWandData withMode(Mode mode) {
        return new SwappingWandData(mode, this.state, this.offhand, this.hardness);
    }

    public SwappingWandData withOffhand(boolean b) {
        return new SwappingWandData(this.mode, this.state, b, this.hardness);
    }

    public SwappingWandData withHardness(float hardness) {
        return new SwappingWandData(this.mode, this.state, this.offhand, Float.valueOf(hardness));
    }

    public static enum Mode {
        MODE_3X3("3x3"),
        MODE_5X5("5x5"),
        MODE_7X7("7x7"),
        MODE_SINGLE("single");

        private final String description;

        private Mode(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public Mode next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> MODE_5X5;
                case 1 -> MODE_7X7;
                case 2 -> MODE_SINGLE;
                case 3 -> MODE_3X3;
            };
        }
    }
}

