/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands.modules.buildingwands.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public record BuildingWandData(Mode mode, OrientationMode orientationMode, List<UndoState> undoStates) {
    public static final int MAX_UNDO = 3;
    public static final BuildingWandData DEFAULT = new BuildingWandData(Mode.MODE_9, OrientationMode.NORMAL, new ArrayList<UndoState>());
    private static final Codec<UndoState> UNDO_STATE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dimension").forGetter(UndoState::dimension), (App)BlockState.CODEC.fieldOf("state").forGetter(UndoState::state), (App)Codec.list((Codec)BlockPos.CODEC).fieldOf("positions").forGetter(undoState -> new ArrayList<BlockPos>(undoState.positions()))).apply((Applicative)instance, (level, state, positions) -> new UndoState((ResourceKey<Level>)level, (BlockState)state, Set.copyOf(positions))));
    private static final StreamCodec<FriendlyByteBuf, UndoState> UNDO_STATE_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), UndoState::dimension, (StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY), UndoState::state, (StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.collection(HashSet::new)), UndoState::positions, UndoState::new);
    public static final Codec<BuildingWandData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(Mode::valueOf, Enum::name).fieldOf("mode").forGetter(BuildingWandData::mode), (App)Codec.STRING.xmap(OrientationMode::valueOf, Enum::name).fieldOf("orientationMode").forGetter(BuildingWandData::orientationMode), (App)Codec.list(UNDO_STATE_CODEC).fieldOf("undo").forGetter(BuildingWandData::undoStates)).apply((Applicative)instance, BuildingWandData::new));
    public static final StreamCodec<FriendlyByteBuf, BuildingWandData> STREAM_CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(Mode.class), BuildingWandData::mode, (StreamCodec)NeoForgeStreamCodecs.enumCodec(OrientationMode.class), BuildingWandData::orientationMode, (StreamCodec)UNDO_STATE_STREAM_CODEC.apply(ByteBufCodecs.list()), BuildingWandData::undoStates, BuildingWandData::new);

    public int findUndoStateIndex(ResourceKey<Level> dimension, BlockPos pos) {
        for (int i = 0; i < this.undoStates.size(); ++i) {
            UndoState undoState = this.undoStates.get(i);
            if (!undoState.dimension().equals(dimension) || !undoState.positions().contains(pos)) continue;
            return i;
        }
        return -1;
    }

    public BuildingWandData pushUndoState(UndoState undoState) {
        List<UndoState> newUndoStates = new ArrayList<UndoState>(this.undoStates);
        newUndoStates.addFirst(undoState);
        if (newUndoStates.size() > 3) {
            newUndoStates = newUndoStates.subList(0, 3);
        }
        return new BuildingWandData(this.mode, this.orientationMode, newUndoStates);
    }

    public BuildingWandData withMode(Mode mode) {
        return new BuildingWandData(mode, this.orientationMode, this.undoStates);
    }

    public BuildingWandData withOrientationMode(OrientationMode orientationMode) {
        return new BuildingWandData(this.mode, orientationMode, this.undoStates);
    }

    public static enum Mode {
        MODE_9("9 blocks", 9),
        MODE_9ROW("9 blocks row", 9),
        MODE_25("25 blocks", 25),
        MODE_25ROW("25 blocks row", 25),
        MODE_SINGLE("single", 1);

        private final String description;
        private final int amount;

        private Mode(String description, int amount) {
            this.description = description;
            this.amount = amount;
        }

        public String getDescription() {
            return this.description;
        }

        public int getAmount() {
            return this.amount;
        }

        public Mode next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> MODE_9ROW;
                case 1 -> MODE_25;
                case 2 -> MODE_25ROW;
                case 3 -> MODE_SINGLE;
                case 4 -> MODE_9;
            };
        }
    }

    public static enum OrientationMode {
        NORMAL("Normal"),
        ROTATED("Rotated");

        private final String description;

        private OrientationMode(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public OrientationMode next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> ROTATED;
                case 1 -> NORMAL;
            };
        }
    }

    public record UndoState(ResourceKey<Level> dimension, BlockState state, Set<BlockPos> positions) {
    }
}

