/*
 * Decompiled with CFR 0.152.
 */
package romelo333.notenoughwands;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import romelo333.notenoughwands.modules.protectionwand.ProtectedBlocks;
import romelo333.notenoughwands.modules.protectionwand.ProtectionWandConfiguration;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        LevelAccessor world = event.getLevel();
        if (world.isClientSide()) {
            return;
        }
        BlockPos pos = event.getPos();
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks((Level)world);
        if (protectedBlocks.isProtected((Level)world, pos)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDetonate(ExplosionEvent.Detonate event) {
        Level world = event.getLevel();
        if (world.isClientSide) {
            return;
        }
        ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
        if (!protectedBlocks.hasProtections()) {
            return;
        }
        List affectedBlocks = event.getAffectedBlocks();
        int i = 0;
        while (i < affectedBlocks.size()) {
            BlockPos block = (BlockPos)affectedBlocks.get(i);
            if (protectedBlocks.isProtected(world, block)) {
                affectedBlocks.remove(i);
                continue;
            }
            ++i;
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent.LeftClickBlock event) {
        ForgeEventHandlers.protect((PlayerInteractEvent)event, (ICancellableEvent)event);
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent.RightClickBlock event) {
        ForgeEventHandlers.protect((PlayerInteractEvent)event, (ICancellableEvent)event);
    }

    private static void protect(PlayerInteractEvent event, ICancellableEvent cancellable) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        if (world.isClientSide) {
            if (ProtectedBlocks.isProtectedClientSide(world, pos)) {
                cancellable.setCanceled(true);
            }
        } else {
            ProtectedBlocks protectedBlocks = ProtectedBlocks.getProtectedBlocks(world);
            if (protectedBlocks != null && protectedBlocks.isProtected(world, pos)) {
                if (((Boolean)ProtectionWandConfiguration.interactionProtection.get()).booleanValue()) {
                    cancellable.setCanceled(true);
                } else if (event instanceof PlayerInteractEvent.LeftClickBlock) {
                    cancellable.setCanceled(true);
                }
                return;
            }
        }
    }
}

