/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.containers;

import com.direwolf20.justdirethings.common.containers.basecontainers.BaseContainer;
import com.direwolf20.justdirethings.common.items.PotionCanister;
import com.direwolf20.justdirethings.setup.Registration;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class ToolSettingContainer
extends BaseContainer {
    public Player playerEntity;
    public static final ResourceLocation EMPTY_ARMOR_SLOT_HELMET = ResourceLocation.parse((String)"item/empty_armor_slot_helmet");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_CHESTPLATE = ResourceLocation.parse((String)"item/empty_armor_slot_chestplate");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_LEGGINGS = ResourceLocation.parse((String)"item/empty_armor_slot_leggings");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_BOOTS = ResourceLocation.parse((String)"item/empty_armor_slot_boots");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_SHIELD = ResourceLocation.parse((String)"item/empty_armor_slot_shield");
    static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{EMPTY_ARMOR_SLOT_BOOTS, EMPTY_ARMOR_SLOT_LEGGINGS, EMPTY_ARMOR_SLOT_CHESTPLATE, EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public final List<Slot> dynamicSlots = new ArrayList<Slot>();
    public ComponentItemHandler componentItemHandler;

    public ToolSettingContainer(int windowId, Inventory playerInventory, Player player, FriendlyByteBuf extraData) {
        this(windowId, playerInventory, player);
    }

    public ToolSettingContainer(int windowId, Inventory playerInventory, Player player) {
        super((MenuType)Registration.Tool_Settings_Container.get(), windowId);
        this.playerEntity = player;
        this.addPlayerSlots(playerInventory, 8, 84);
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslot = SLOT_IDS[k];
            this.addSlot(new Slot((Container)playerInventory, 39 - k, 44 + k * 18, 66){

                public void setByPlayer(ItemStack p_270969_, ItemStack p_299918_) {
                    ToolSettingContainer.onEquipItem(ToolSettingContainer.this.playerEntity, equipmentslot, p_270969_, p_299918_);
                    super.setByPlayer(p_270969_, p_299918_);
                }

                public int getMaxStackSize() {
                    return 1;
                }

                public boolean mayPlace(ItemStack p_39746_) {
                    return p_39746_.canEquip(equipmentslot, (LivingEntity)ToolSettingContainer.this.playerEntity);
                }

                public boolean mayPickup(Player p_39744_) {
                    ItemStack itemstack = this.getItem();
                    return !itemstack.isEmpty() && !p_39744_.isCreative() && EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) ? false : super.mayPickup(p_39744_);
                }

                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)TEXTURE_EMPTY_SLOTS[equipmentslot.getIndex()]);
                }
            });
        }
        this.addSlot(new Slot((Container)playerInventory, 40, 116, 66){

            public void setByPlayer(ItemStack p_270479_, ItemStack p_299920_) {
                ToolSettingContainer.onEquipItem(ToolSettingContainer.this.playerEntity, EquipmentSlot.OFFHAND, p_270479_, p_299920_);
                super.setByPlayer(p_270479_, p_299920_);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        this.refreshSlots(player.getMainHandItem());
    }

    private void addSelectedItemSlots() {
        for (int i = 0; i < this.componentItemHandler.getSlots(); ++i) {
            int x = 134 + i % 2 * 18;
            int y = 66 - i / 2 * 18;
            SlotItemHandler slot = new SlotItemHandler(this, (IItemHandler)this.componentItemHandler, i, x, y){

                public boolean mayPlace(ItemStack stack) {
                    return stack.getItem() instanceof PotionCanister;
                }
            };
            this.addSlot((Slot)slot);
            this.dynamicSlots.add((Slot)slot);
        }
    }

    public void clearDynamicSlots() {
        for (Slot slot : this.dynamicSlots) {
            this.slots.remove((Object)slot);
            this.remoteSlots.remove(this.remoteSlots.size() - 1);
        }
        this.dynamicSlots.clear();
    }

    public void refreshSlots(ItemStack selectedStack) {
        this.clearDynamicSlots();
        this.componentItemHandler = this.getItemSlots(selectedStack);
        if (this.componentItemHandler != null) {
            this.addSelectedItemSlots();
        }
    }

    public ComponentItemHandler getItemSlots(ItemStack itemStack) {
        IItemHandler itemHandler = (IItemHandler)itemStack.getCapability(Capabilities.ItemHandler.ITEM);
        if (itemHandler instanceof ComponentItemHandler) {
            ComponentItemHandler componentItemHandler = (ComponentItemHandler)itemHandler;
            return componentItemHandler;
        }
        return null;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot slot;
        ItemStack itemstack = ItemStack.EMPTY;
        if (!this.dynamicSlots.isEmpty() && (slot = (Slot)this.slots.get(index)).hasItem()) {
            ItemStack currentStack = slot.getItem();
            if (index >= 41 && !this.moveItemStackTo(currentStack, 0, 36, true)) {
                return ItemStack.EMPTY;
            }
            if (index < 36 && !this.moveItemStackTo(currentStack, 41, 41 + this.dynamicSlots.size(), false)) {
                return ItemStack.EMPTY;
            }
            if (currentStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (currentStack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, currentStack);
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player pPlayer) {
        return true;
    }

    static void onEquipItem(Player pPlayer, EquipmentSlot pSlot, ItemStack pNewItem, ItemStack pOldItem) {
        pPlayer.onEquipItem(pSlot, pOldItem, pNewItem);
    }
}

