/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.blockentities;

import com.direwolf20.justdirethings.common.blockentities.FluidCollectorT1BE;
import com.direwolf20.justdirethings.common.blockentities.basebe.AreaAffectingBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FilterableBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineContainerData;
import com.direwolf20.justdirethings.common.capabilities.MachineEnergyStorage;
import com.direwolf20.justdirethings.common.containers.handlers.FilterBasicHandler;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.interfacehelpers.AreaAffectingData;
import com.direwolf20.justdirethings.util.interfacehelpers.FilterData;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.FakePlayer;

public class FluidCollectorT2BE
extends FluidCollectorT1BE
implements PoweredMachineBE,
AreaAffectingBE,
FilterableBE {
    public FilterData filterData = new FilterData();
    public AreaAffectingData areaAffectingData = new AreaAffectingData((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING));
    public final PoweredMachineContainerData poweredMachineData = new PoweredMachineContainerData(this);

    public FluidCollectorT2BE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)Registration.FluidCollectorT2BE.get(), pPos, pBlockState);
    }

    @Override
    public int getMaxMB() {
        return 32000;
    }

    @Override
    public PoweredMachineContainerData getContainerData() {
        return this.poweredMachineData;
    }

    @Override
    public MachineEnergyStorage getEnergyStorage() {
        return (MachineEnergyStorage)((Object)this.getData(Registration.ENERGYSTORAGE_MACHINES));
    }

    @Override
    public int getStandardEnergyCost() {
        return 500;
    }

    @Override
    public AreaAffectingData getAreaAffectingData() {
        return this.areaAffectingData;
    }

    @Override
    public FilterBasicHandler getFilterHandler() {
        return (FilterBasicHandler)((Object)this.getData(Registration.HANDLER_BASIC_FILTER));
    }

    @Override
    public FilterData getFilterData() {
        return this.filterData;
    }

    @Override
    public boolean canCollect() {
        return this.hasEnoughPower(this.getStandardEnergyCost());
    }

    @Override
    public boolean collectFluid(BlockPos blockPos) {
        boolean success = super.collectFluid(blockPos);
        if (success) {
            this.extractEnergy(this.getStandardEnergyCost(), false);
        }
        return success;
    }

    @Override
    public List<BlockPos> findSpotsToCollect(FakePlayer fakePlayer) {
        AABB area = this.getAABB(this.getBlockPos());
        return BlockPos.betweenClosedStream((int)((int)area.minX), (int)((int)area.minY), (int)((int)area.minZ), (int)((int)area.maxX - 1), (int)((int)area.maxY - 1), (int)((int)area.maxZ - 1)).filter(blockPos -> this.isBlockPosValid((BlockPos)blockPos, fakePlayer)).map(BlockPos::immutable).sorted(Comparator.comparingDouble(x -> x.distSqr((Vec3i)this.getBlockPos()))).collect(Collectors.toList());
    }

    @Override
    public boolean isBlockPosValid(BlockPos blockPos, FakePlayer fakePlayer) {
        if (!super.isBlockPosValid(blockPos, fakePlayer)) {
            return false;
        }
        Block block = this.level.getBlockState(blockPos).getBlock();
        if (!(block instanceof LiquidBlock)) {
            return false;
        }
        LiquidBlock liquidBlock = (LiquidBlock)block;
        return this.isStackValidFilter(liquidBlock);
    }
}

