/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens.widgets;

import com.direwolf20.justdirethings.client.screens.basescreens.SensorScreenInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStateScrollList
extends ObjectSelectionList<BlockStateEntry> {
    private final int listWidth;
    private ItemStack stateStack;
    private SensorScreenInterface parent;

    private static String stripControlCodes(String value) {
        return StringUtil.stripColor((String)value);
    }

    public BlockStateScrollList(SensorScreenInterface parent, int left, int listWidth, int top, int bottom) {
        Minecraft minecraft = Minecraft.getInstance();
        Objects.requireNonNull(parent.getFontRenderer());
        super(minecraft, listWidth, bottom - top, top, 9 * 2 + 8);
        this.stateStack = ItemStack.EMPTY;
        this.parent = parent;
        this.listWidth = listWidth;
        this.refreshList();
        this.setX(left);
    }

    public ItemStack getStateStack() {
        return this.stateStack;
    }

    public void setStateStack(ItemStack stack) {
        this.stateStack = stack;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.listWidth - 5;
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    public void refreshList() {
        block5: {
            Item block;
            block4: {
                this.clearEntries();
                Item item = this.stateStack.getItem();
                if (!(item instanceof BlockItem)) break block4;
                BlockItem blockItem = (BlockItem)item;
                block = blockItem.getBlock();
                BlockState defaultState = block.defaultBlockState();
                for (Property property : defaultState.getProperties()) {
                    ArrayList values = new ArrayList(property.getPossibleValues());
                    Comparable setValue = this.parent.getValue(property);
                    boolean isAny = false;
                    if (setValue == null) {
                        setValue = defaultState.getValue(property);
                        isAny = true;
                    }
                    this.addEntry((AbstractSelectionList.Entry)new BlockStateEntry(property, setValue, defaultState.getValue(property), this.parent, values, isAny));
                }
                break block5;
            }
            block = this.stateStack.getItem();
            if (!(block instanceof BucketItem)) break block5;
            BucketItem bucketItem = (BucketItem)block;
            BlockState defaultState = bucketItem.content.defaultFluidState().createLegacyBlock();
            for (Property property : defaultState.getProperties()) {
                ArrayList values = new ArrayList(property.getPossibleValues());
                Comparable setValue = this.parent.getValue(property);
                boolean isAny = false;
                if (setValue == null) {
                    setValue = defaultState.getValue(property);
                    isAny = true;
                }
                this.addEntry((AbstractSelectionList.Entry)new BlockStateEntry(property, setValue, defaultState.getValue(property), this.parent, values, isAny));
            }
        }
    }

    public void renderWidget(GuiGraphics p_282708_, int p_283242_, int p_282891_, float p_283683_) {
        this.renderContentBackground(p_282708_);
        super.renderWidget(p_282708_, p_283242_, p_282891_, p_283683_);
    }

    protected void renderContentBackground(GuiGraphics guiGraphics) {
        guiGraphics.fillGradient(this.getX(), this.getY(), this.getRight(), this.getBottom(), -1072689136, -804253680);
    }

    public class BlockStateEntry
    extends ObjectSelectionList.Entry<BlockStateEntry> {
        private final Property<?> property;
        private final SensorScreenInterface parent;
        private Comparable<?> currentValue;
        private final List<Comparable<?>> possibleValues;
        private final int anyIndex;
        private boolean isAny;
        private Map<Property<?>, Comparable<?>> assignedValues = new HashMap();

        BlockStateEntry(Property<?> property, Comparable<?> currentValue, Comparable<?> defaultValue, SensorScreenInterface parent, List<Comparable<?>> possibleValues, boolean isAny) {
            this.property = property;
            this.currentValue = currentValue;
            this.anyIndex = possibleValues.indexOf(defaultValue);
            this.parent = parent;
            this.possibleValues = possibleValues;
            this.isAny = isAny;
        }

        public Component getNarration() {
            return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.property.getName()});
        }

        public void render(GuiGraphics guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            MutableComponent name = Component.literal((String)BlockStateScrollList.stripControlCodes(this.property.getName()));
            MutableComponent value = Component.literal((String)BlockStateScrollList.stripControlCodes(this.isAny ? "ANY" : this.currentValue.toString()));
            Font font = this.parent.getFontRenderer();
            guiGraphics.drawString(font, Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{font.substrByWidth((FormattedText)name, BlockStateScrollList.this.listWidth)})), left + 3, top + 2, 0xFFFFFF, false);
            FormattedCharSequence formattedCharSequence = Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{font.substrByWidth((FormattedText)value, BlockStateScrollList.this.listWidth)}));
            Objects.requireNonNull(font);
            guiGraphics.drawString(font, formattedCharSequence, left + 3, top + 2 + 9, 0xCCCCCC, false);
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            int nextIndex;
            BlockStateScrollList.this.setSelected((AbstractSelectionList.Entry)this);
            int currentIndex = this.possibleValues.indexOf(this.currentValue);
            if (currentIndex == this.anyIndex && this.isAny) {
                nextIndex = this.anyIndex;
                this.isAny = false;
            } else {
                nextIndex = (currentIndex + 1) % this.possibleValues.size();
                if (nextIndex == this.anyIndex) {
                    this.isAny = true;
                }
            }
            this.currentValue = this.possibleValues.get(nextIndex);
            this.parent.setPropertyValue(this.property, this.currentValue, this.isAny);
            return false;
        }
    }
}

