/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.blocks;

import com.flanks255.simplylight.blocks.RotatableLamp;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;

public class ThinLamp
extends RotatableLamp {
    private final double thickness;
    public final DyeColor color;

    public ThinLamp(double thickness, DyeColor colorIn) {
        super(BlockBehaviour.Properties.of().pushReaction(PushReaction.NORMAL).lightLevel($ -> 15).strength(1.0f));
        this.thickness = thickness;
        this.color = colorIn;
        this.UP = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)thickness, (double)16.0);
        this.DOWN = Block.box((double)0.0, (double)(16.0 - thickness), (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        this.EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)thickness, (double)16.0, (double)16.0);
        this.WEST = Block.box((double)(16.0 - thickness), (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        this.NORTH = Block.box((double)0.0, (double)0.0, (double)(16.0 - thickness), (double)16.0, (double)16.0, (double)16.0);
        this.SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)thickness);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext useContext) {
        boolean waterlogged;
        BlockPos pos = useContext.getClickedPos().relative(useContext.getClickedFace().getOpposite());
        boolean bl = waterlogged = useContext.getLevel().getFluidState(useContext.getClickedPos()).getType() == Fluids.WATER;
        if (useContext.getPlayer() != null && useContext.getLevel().getBlockState(pos).getBlock() instanceof ThinLamp && !useContext.getPlayer().isCrouching()) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)useContext.getLevel().getBlockState(pos).getValue((Property)BlockStateProperties.FACING)));
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)useContext.getClickedFace())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    @Override
    public void addLang(BiConsumer<String, String> consumer) {
        String type2;
        String base = this.getDescriptionId();
        String colorname = switch (this.color) {
            case DyeColor.RED -> "Red";
            case DyeColor.BLUE -> "Blue";
            case DyeColor.CYAN -> "Cyan";
            case DyeColor.GRAY -> "Gray";
            case DyeColor.LIME -> "Lime";
            case DyeColor.MAGENTA -> "Magenta";
            case DyeColor.PINK -> "Pink";
            case DyeColor.BLACK -> "Black";
            case DyeColor.BROWN -> "Brown";
            case DyeColor.GREEN -> "Green";
            case DyeColor.ORANGE -> "Orange";
            case DyeColor.PURPLE -> "Purple";
            case DyeColor.YELLOW -> "Yellow";
            case DyeColor.LIGHT_BLUE -> "Light Blue";
            case DyeColor.LIGHT_GRAY -> "Light Gray";
            default -> "";
        };
        String type = this.thickness == 8.0 ? "Slab" : "Panel";
        String string = type2 = this.thickness == 8.0 ? "half-slab" : "LED panel";
        if (this.color == DyeColor.WHITE) {
            consumer.accept(base, "Illuminant " + type);
        } else {
            consumer.accept(base, "Illuminant " + colorname + " " + type);
        }
        if (this.color != DyeColor.WHITE) {
            return;
        }
        consumer.accept(base + ".info", "Simple " + type2 + " light,");
        consumer.accept(base + ".info2", "Place in any direction.");
    }
}

