/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lmft.utils;

import io.wispforest.lmft.utils.MethodHandleUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.nio.file.Path;
import org.jetbrains.annotations.Nullable;

public class PathUtils {
    @Nullable
    public static Path getConfigPath() {
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        Path path = PathUtils.getFabricConfigPath(lookup);
        if (path == null) {
            path = PathUtils.getNeoforgeConfigPath(lookup);
        }
        if (path == null) {
            path = PathUtils.getForgeConfigPath(lookup);
        }
        return path;
    }

    @Nullable
    private static Path getFabricConfigPath(MethodHandles.Lookup lookup) {
        try {
            Class<?> fLoaderClass = MethodHandleUtils.findClass("net.fabricmc.loader.api.FabricLoader");
            if (fLoaderClass == null) {
                return null;
            }
            MethodHandle instanceMethod = lookup.findStatic(fLoaderClass, "getInstance", MethodType.methodType(fLoaderClass));
            MethodHandle configMethod = lookup.findVirtual(fLoaderClass, "getConfigDir", MethodType.methodType(Path.class));
            return (Path)MethodHandleUtils.wrapForErrors("getFabricConfigPath", () -> configMethod.invoke(instanceMethod.invoke()));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            return null;
        }
    }

    @Nullable
    private static Path getNeoforgeConfigPath(MethodHandles.Lookup lookup) {
        try {
            Class<?> fmlPathsClass = MethodHandleUtils.findClass("net.neoforged.fml.loading.FMLPaths");
            if (fmlPathsClass == null) {
                return null;
            }
            VarHandle instanceMethod = lookup.findStaticVarHandle(fmlPathsClass, "CONFIGDIR", fmlPathsClass);
            MethodHandle configMethod = lookup.findVirtual(fmlPathsClass, "get", MethodType.methodType(Path.class));
            return (Path)MethodHandleUtils.wrapForErrors("getNeoforgeConfigPath", () -> configMethod.invoke(instanceMethod.get()));
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
            return null;
        }
    }

    @Nullable
    private static Path getForgeConfigPath(MethodHandles.Lookup lookup) {
        try {
            Class<?> fmlPathsClass = MethodHandleUtils.findClass("net.minecraftforge.fml.loading");
            if (fmlPathsClass == null) {
                return null;
            }
            VarHandle instanceMethod = lookup.findStaticVarHandle(fmlPathsClass, "CONFIGDIR", fmlPathsClass);
            MethodHandle configMethod = lookup.findVirtual(fmlPathsClass, "get", MethodType.methodType(Path.class));
            return (Path)MethodHandleUtils.wrapForErrors("getForgeConfigPath", () -> configMethod.invoke(instanceMethod.get()));
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
            return null;
        }
    }
}

