/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.hive;

import com.glodblock.github.glodium.util.GlodUtil;
import com.glodblock.github.modularbees.common.MBConfig;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.blocks.hive.Hive;
import com.glodblock.github.modularbees.common.caps.FluidHandlerHost;
import com.glodblock.github.modularbees.common.caps.ItemHandlerHost;
import com.glodblock.github.modularbees.common.inventory.IO;
import com.glodblock.github.modularbees.common.inventory.MBBigItemInventory;
import com.glodblock.github.modularbees.common.inventory.MBFluidInventory;
import com.glodblock.github.modularbees.common.inventory.MBItemInventory;
import com.glodblock.github.modularbees.common.inventory.SlotListener;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBModularComponent;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBModularCore;
import com.glodblock.github.modularbees.common.tileentities.hive.TileBeehiveAlveary;
import com.glodblock.github.modularbees.common.tileentities.hive.TileBeehiveDragon;
import com.glodblock.github.modularbees.common.tileentities.hive.TileBeehiveFeeder;
import com.glodblock.github.modularbees.common.tileentities.hive.TileBeehiveOverclocker;
import com.glodblock.github.modularbees.common.tileentities.hive.TileBeehiveStacker;
import com.glodblock.github.modularbees.common.tileentities.hive.TileBeehiveTreater;
import com.glodblock.github.modularbees.util.BeeTable;
import com.glodblock.github.modularbees.util.GameUtil;
import com.glodblock.github.modularbees.util.StackCacheMap;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivelib.registry.LibItems;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileModularBeehive
extends TileMBModularCore
implements ItemHandlerHost,
FluidHandlerHost,
SlotListener {
    private static final int WAITING_TICKS = ProductiveBeesConfig.GENERAL.timeInHive.getAsInt();
    @Nullable
    private ObjectSet<BlockPos> allPos;
    @Nullable
    private ObjectSet<ChunkPos> allChunk;
    public static final Set<Item> ACCEPT_UPGRADES = Set.of((Item)LibItems.UPGRADE_TIME.get(), (Item)LibItems.UPGRADE_BLOCK.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY_2.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY_3.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY_4.get());
    protected final MBBigItemInventory outputs = (MBBigItemInventory)new MBBigItemInventory(this, 18).outputOnly();
    protected final MBItemInventory upgrade = new MBItemInventory(this, 4, s -> ACCEPT_UPGRADES.contains(s.getItem())).setSlotLimit(1);
    protected final MBItemInventory bottle = new MBItemInventory(this, 2, MBItemInventory.ItemFilter.of(Items.GLASS_BOTTLE)).setIO(0, IO.IN).setIO(1, IO.OUT);
    protected final MBFluidInventory honey = new MBFluidInventory(this, 8000).outputOnly();
    private final IItemHandler exposed = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.outputs, this.bottle});
    private final BeeTable table = new BeeTable(this, this::lookup);
    private float process = 0.0f;
    private float tickSpeed = 1.0f;
    private final List<ItemStack> sending = new ArrayList<ItemStack>();
    private boolean stuck = false;
    private boolean blockMode = false;
    private float upgradeMultiplier = 1.0f;

    public TileModularBeehive(BlockPos pos, BlockState state) {
        super(GlodUtil.getTileType(TileModularBeehive.class, TileModularBeehive::new, (Block)MBSingletons.MODULAR_BEEHIVE_CORE), pos, state);
    }

    @Override
    protected void logicTick(@NotNull Level world, BlockState state, List<TileMBModularComponent> components) {
        if (!this.notLoaded()) {
            this.fillBottle();
            if (this.table.getBeeCount() <= 0) {
                return;
            }
            float overclock = 1.0f;
            if (!this.stuck) {
                for (TileMBModularComponent component : components) {
                    if (!(component instanceof TileBeehiveOverclocker)) continue;
                    TileBeehiveOverclocker overclocker = (TileBeehiveOverclocker)component;
                    overclock += overclocker.getBoostAndConsume(this.table.getBeeCount());
                }
                overclock = Math.max(1.0f, overclock);
                this.addTick(overclock);
            }
            if (!this.sending.isEmpty() && !this.stuck) {
                for (int i = 0; i < this.sending.size(); ++i) {
                    ItemStack stack = this.sending.get(i).copy();
                    for (int x = 0; x < this.outputs.getSlots() && !stack.isEmpty(); ++x) {
                        stack = this.outputs.forceInsertItem(x, stack, false);
                    }
                    this.sending.set(i, stack);
                }
                this.sending.removeIf(ItemStack::isEmpty);
                if (!this.sending.isEmpty()) {
                    this.stuck = true;
                }
                this.setChanged();
            }
            if (this.sending.isEmpty() && this.process >= (float)WAITING_TICKS) {
                this.process = 0.0f;
                StackCacheMap outputs = new StackCacheMap(world.getRandom());
                this.table.collectOutput(world, outputs::add);
                float treaterMultiplier = 1.0f;
                int working = this.table.getWorkingBee();
                TileBeehiveDragon dragonHive = null;
                for (TileMBModularComponent component : components) {
                    TileBeehiveDragon dragon;
                    if (component instanceof TileBeehiveTreater) {
                        TileBeehiveTreater treater = (TileBeehiveTreater)component;
                        treaterMultiplier += treater.getBoostAndConsume(working);
                        continue;
                    }
                    if (dragonHive != null || !(component instanceof TileBeehiveDragon)) continue;
                    dragonHive = dragon = (TileBeehiveDragon)component;
                }
                treaterMultiplier = Math.max(1.0f, treaterMultiplier);
                this.sending.addAll(outputs.getItems(this.blockMode, this.upgradeMultiplier * treaterMultiplier));
                int honeyAmt = world.getRandom().nextInt(working / 2, working + 1) * (Integer)MBConfig.HONEY_PRODUCE_BASE.get();
                if (honeyAmt > 0) {
                    this.honey.forceFill(new FluidStack((Fluid)ModFluids.HONEY.get(), honeyAmt), IFluidHandler.FluidAction.EXECUTE);
                }
                if (dragonHive != null && this.table.getDragonBee() > 0) {
                    dragonHive.addDragonBreath(this.table.getDragonBee(), world);
                }
                this.setChanged();
            }
        }
    }

    public void addOutput(ItemStack stack) {
        if (!stack.isEmpty()) {
            this.sending.add(stack);
            this.setChanged();
        }
    }

    public void fillBottle() {
        ItemStack left;
        if (this.honey.getFluidAmount() >= 250 && this.bottle.getStackInSlot(0).getItem() == Items.GLASS_BOTTLE && (left = this.bottle.forceInsertItem(1, new ItemStack((ItemLike)Items.HONEY_BOTTLE), false)).isEmpty()) {
            this.honey.drain(250, IFluidHandler.FluidAction.EXECUTE);
            this.bottle.forceExtractItem(0, 1, false);
        }
    }

    public void addTick(float overclock) {
        this.process += this.tickSpeed * overclock;
    }

    public void onFeederChange(IItemHandler inv, int slot) {
        this.table.feederUpdate(inv, slot);
    }

    public void onBeeChange() {
        this.table.clear();
        for (TileBeehiveAlveary alveary : this.getComponents(TileBeehiveAlveary.class)) {
            alveary.collectBees(this.table::loadBee);
        }
    }

    private TileBeehiveFeeder.FeedSlot lookup(BeehiveBlockEntity.BeeData data) {
        Entity entity;
        if (this.getLevel() != null && (entity = data.toOccupant().createEntity(this.getLevel(), this.getBlockPos())) instanceof Bee) {
            Bee bee = (Bee)entity;
            ArrayList<TileBeehiveFeeder> feeders = new ArrayList<TileBeehiveFeeder>(this.getComponents(TileBeehiveFeeder.class));
            Collections.shuffle(feeders);
            for (TileBeehiveFeeder feeder : feeders) {
                TileBeehiveFeeder.FeedSlot result = feeder.checkFlower(bee);
                if (!result.isSuccess()) continue;
                return result;
            }
        }
        return TileBeehiveFeeder.FeedSlot.FAIL;
    }

    @NotNull
    public Collection<ChunkPos> getChunks() {
        if (this.allChunk == null) {
            this.allChunk = new ObjectOpenHashSet();
            for (BlockPos pos : this.getPoses()) {
                this.allChunk.add((Object)new ChunkPos(pos));
            }
        }
        return this.allChunk;
    }

    @NotNull
    public Collection<BlockPos> getPoses() {
        if (this.allPos == null) {
            this.allPos = new ObjectOpenHashSet();
            Direction face = MBSingletons.MODULAR_BEEHIVE_CORE.getFacing(this.getBlockState());
            if (face == null) {
                return this.allPos;
            }
            BlockPos corePos = this.getBlockPos();
            for (int y = corePos.getY() - 1; y <= corePos.getY() + 1; ++y) {
                int upperX;
                int upperZ;
                if (face.getAxis() == Direction.Axis.X) {
                    upperZ = corePos.getZ() + 1;
                    lowerZ = corePos.getZ() - 1;
                    upperX = corePos.getX() + (-face.getStepX() + 1);
                    lowerX = corePos.getX() - (face.getStepX() + 1);
                } else if (face.getAxis() == Direction.Axis.Z) {
                    upperZ = corePos.getZ() + (-face.getStepZ() + 1);
                    lowerZ = corePos.getZ() - (face.getStepZ() + 1);
                    upperX = corePos.getX() + 1;
                    lowerX = corePos.getX() - 1;
                } else {
                    return this.allPos;
                }
                for (int x = lowerX; x <= upperX; ++x) {
                    for (int z = lowerZ; z <= upperZ; ++z) {
                        this.allPos.add((Object)new BlockPos(x, y, z));
                    }
                }
            }
        }
        return this.allPos;
    }

    @Override
    public void onStateChange() {
        this.allChunk = null;
        this.allPos = null;
        this.table.clear();
        this.outputs.setMultiplier(1);
        super.onStateChange();
    }

    @Override
    public boolean isStructurePos(BlockPos pos) {
        Direction face = MBSingletons.MODULAR_BEEHIVE_CORE.getFacing(this.getBlockState());
        if (face == null) {
            return false;
        }
        return this.getPoses().contains(pos);
    }

    @Override
    public boolean isStructurePos(ChunkPos pos) {
        Direction face = MBSingletons.MODULAR_BEEHIVE_CORE.getFacing(this.getBlockState());
        if (face == null) {
            return false;
        }
        return this.getChunks().contains(pos);
    }

    @Override
    protected boolean buildStructure(Consumer<TileMBModularComponent> collector, Level world) {
        Direction face = MBSingletons.MODULAR_BEEHIVE_CORE.getFacing(this.getBlockState());
        if (face == null) {
            return false;
        }
        Collection<BlockPos> poses = this.getPoses();
        if (poses.isEmpty()) {
            return false;
        }
        for (BlockPos pos : poses) {
            TileMBModularComponent hivePart;
            if (pos.equals((Object)this.getBlockPos())) continue;
            BlockEntity te = world.getBlockEntity(pos);
            if (te instanceof TileMBModularComponent && !(hivePart = (TileMBModularComponent)te).isActive()) {
                Block block = te.getBlockState().getBlock();
                if (!(block instanceof Hive)) {
                    return false;
                }
                collector.accept(hivePart);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public void formStructure() {
        super.formStructure();
        if (this.isFormed()) {
            this.onBeeChange();
            int stacker = this.getComponents(TileBeehiveStacker.class).size();
            this.outputs.setMultiplier(stacker * (Integer)MBConfig.STACKER_MULTIPLIER.get());
        }
    }

    @Override
    public void saveTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveTag(data, provider);
        data.put("outputs", (Tag)this.outputs.serializeNBT(provider));
        data.put("upgrade", (Tag)this.upgrade.serializeNBT(provider));
        data.put("bottle", (Tag)this.bottle.serializeNBT(provider));
        CompoundTag tank = new CompoundTag();
        this.honey.writeToNBT(provider, tank);
        data.put("honey", (Tag)tank);
        ListTag tag = GameUtil.saveItemList(this.sending, provider);
        if (!tag.isEmpty()) {
            data.put("sending", (Tag)tag);
        }
    }

    @Override
    public void loadTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadTag(data, provider);
        this.outputs.deserializeNBT(provider, data.getCompound("outputs"));
        this.upgrade.deserializeNBT(provider, data.getCompound("upgrade"));
        this.bottle.deserializeNBT(provider, data.getCompound("bottle"));
        this.honey.readFromNBT(provider, data.getCompound("honey"));
        if (data.contains("sending")) {
            ListTag tag = data.getList("sending", 10);
            GameUtil.loadItemList(tag, provider, this.sending);
        }
    }

    @Override
    public MBItemInventory getHandlerByName(String name) {
        return switch (name) {
            case "outputs" -> this.outputs;
            case "upgrade" -> this.upgrade;
            case "bottle" -> this.bottle;
            default -> null;
        };
    }

    public void onLoad() {
        super.onLoad();
        this.updateUpgrade();
    }

    @Override
    public void addInventoryDrops(Level level, @NotNull BlockPos pos, List<ItemStack> drops) {
        drops.addAll(this.outputs.toList());
        drops.addAll(this.upgrade.toList());
        drops.addAll(this.bottle.toList());
    }

    public MBFluidInventory getFluidInventory() {
        return this.honey;
    }

    @Override
    public IItemHandler getItemInventory() {
        return this.exposed;
    }

    @Override
    public void onChange(IItemHandler inv, int slot) {
        if (inv == this.upgrade) {
            this.updateUpgrade();
        } else if (inv == this.outputs) {
            this.stuck = false;
        }
    }

    private void updateUpgrade() {
        this.blockMode = this.upgrade.countStack(stack -> stack.getItem() == LibItems.UPGRADE_BLOCK.get() || stack.getItem() == LibItems.UPGRADE_PRODUCTIVITY_4.get()) > 0;
        int amt = this.upgrade.countStack((Item)LibItems.UPGRADE_TIME.get());
        this.tickSpeed = (float)(1.0 / (1.0 - (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get() * (double)amt));
        this.upgradeMultiplier = 1.0f;
        this.upgradeMultiplier += (float)((double)this.upgrade.countStack((Item)LibItems.UPGRADE_PRODUCTIVITY.get()) * (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier.get());
        this.upgradeMultiplier += (float)((double)this.upgrade.countStack((Item)LibItems.UPGRADE_PRODUCTIVITY_2.get()) * (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier2.get());
        this.upgradeMultiplier += (float)((double)this.upgrade.countStack((Item)LibItems.UPGRADE_PRODUCTIVITY_3.get()) * (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier3.get());
        this.upgradeMultiplier += (float)((double)this.upgrade.countStack((Item)LibItems.UPGRADE_PRODUCTIVITY_4.get()) * (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier4.get());
    }
}

